/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class JPADefaultDatasourceWriteHandler
extends AbstractWriteAttributeHandler<String> {
    static final JPADefaultDatasourceWriteHandler INSTANCE = new JPADefaultDatasourceWriteHandler();

    private JPADefaultDatasourceWriteHandler() {
        super((ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, false, true), (ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, false, false));
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<String> handbackHolder) throws OperationFailedException {
        String dataSourceName = resolvedValue.asString();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getRequiredService(JPAService.SERVICE_NAME);
        JPAService jpaService = (JPAService)JPAService.class.cast(sc.getService());
        handbackHolder.setHandback((Object)JPAService.getDefaultDataSourceName());
        jpaService.setDefaultDataSourceName(dataSourceName);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handback) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getRequiredService(JPAService.SERVICE_NAME);
        JPAService jpaService = (JPAService)JPAService.class.cast(sc.getValue());
        jpaService.setDefaultDataSourceName(handback);
    }
}

