/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Attribute {
    UNKNOWN((String)null),
    ACQUIRE_TIMEOUT("acquire-timeout"),
    ALIASES("aliases"),
    BATCH_SIZE("batch-size"),
    BATCHING("batching"),
    CACHE("cache"),
    CHUNK_SIZE("chunk-size"),
    CLASS("class"),
    CONCURRENCY_LEVEL("concurrency-level"),
    DATASOURCE("datasource"),
    DEFAULT_CACHE("default-cache"),
    DEFAULT_CACHE_CONTAINER("default-cache-container"),
    EAGER_LOCKING("eager-locking"),
    ENABLED("enabled"),
    EVICTION_EXECUTOR("eviction-executor"),
    EXECUTOR("executor"),
    FETCH_SIZE("fetch-size"),
    FETCH_STATE("fetch-state"),
    FLUSH_TIMEOUT("flush-timeout"),
    INDEXING("indexing"),
    INTERVAL("interval"),
    ISOLATION("isolation"),
    JNDI_NAME("jndi-name"),
    L1_LIFESPAN("l1-lifespan"),
    LIFESPAN("lifespan"),
    LISTENER_EXECUTOR("listener-executor"),
    LOCK_TIMEOUT("lock-timeout"),
    LOCKING("locking"),
    MACHINE("machine"),
    MAX_ENTRIES("max-entries"),
    MAX_IDLE("max-idle"),
    MODE("mode"),
    NAME("name"),
    NAMESPACE("xmlns"),
    OUTBOUND_SOCKET_BINDING("outbound-socket-binding"),
    OWNERS("owners"),
    PASSIVATION("passivation"),
    PATH("path"),
    PREFIX("prefix"),
    PRELOAD("preload"),
    PURGE("purge"),
    QUEUE_FLUSH_INTERVAL("queue-flush-interval"),
    QUEUE_SIZE("queue-size"),
    RACK("rack"),
    RELATIVE_TO("relative-to"),
    REMOTE_TIMEOUT("remote-timeout"),
    REPLICATION_QUEUE_EXECUTOR("replication-queue-executor"),
    SHARED("shared"),
    SINGLETON("singleton"),
    SITE("site"),
    SOCKET_TIMEOUT("socket-timeout"),
    STACK("stack"),
    START("start"),
    STOP_TIMEOUT("stop-timeout"),
    STRATEGY("strategy"),
    STRIPING("striping"),
    TCP_NO_DELAY("tcp-no-delay"),
    TIMEOUT("timeout"),
    TYPE("type"),
    VIRTUAL_NODES("virtual-nodes");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    private Attribute(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

