/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheAdd;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class DistributedCacheAdd
extends SharedStateCacheAdd {
    static final DistributedCacheAdd INSTANCE = new DistributedCacheAdd();

    static ModelNode createOperation(ModelNode address, ModelNode model) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        INSTANCE.populateMode(model, operation);
        INSTANCE.populate(model, operation);
        return operation;
    }

    private DistributedCacheAdd() {
        super(CacheMode.DIST_SYNC);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) {
        super.populate(fromModel, toModel);
        if (fromModel.hasDefined("owners")) {
            toModel.get("owners").set(fromModel.get("owners"));
        }
        if (fromModel.hasDefined("virtual-nodes")) {
            toModel.get("virtual-nodes").set(fromModel.get("virtual-nodes"));
        }
        if (fromModel.hasDefined("l1-lifespan")) {
            toModel.get("l1-lifespan").set(fromModel.get("l1-lifespan"));
        }
    }

    @Override
    void processModelNode(String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) {
        super.processModelNode(containerName, cache, builder, dependencies);
        if (cache.hasDefined("owners")) {
            builder.clustering().hash().numOwners(cache.get("owners").asInt());
        }
        if (cache.hasDefined("virtual-nodes")) {
            builder.clustering().hash().numVirtualNodes(cache.get("virtual-nodes").asInt());
        }
        if (cache.hasDefined("l1-lifespan")) {
            long lifespan = cache.get("l1-lifespan").asLong();
            if (lifespan > 0L) {
                builder.clustering().l1().lifespan(lifespan);
            } else {
                builder.clustering().l1().disable();
            }
        }
    }
}

