/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.List;
import org.jboss.as.clustering.infinispan.subsystem.AddAliasCommand;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerRemove;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheRemove;
import org.jboss.as.clustering.infinispan.subsystem.CacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemDescribe;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemProviders;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLWriter;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.clustering.infinispan.subsystem.RemoveAliasCommand;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.TransportAdd;
import org.jboss.as.clustering.infinispan.subsystem.TransportRemove;
import org.jboss.as.clustering.infinispan.subsystem.TransportWriteAttributeHandler;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class InfinispanExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "infinispan";
    private static final PathElement containerPath = PathElement.pathElement((String)"cache-container");
    private static final PathElement localCachePath = PathElement.pathElement((String)"local-cache");
    private static final PathElement invalidationCachePath = PathElement.pathElement((String)"invalidation-cache");
    private static final PathElement replicatedCachePath = PathElement.pathElement((String)"replicated-cache");
    private static final PathElement distributedCachePath = PathElement.pathElement((String)"distributed-cache");
    private static final PathElement transportPath = PathElement.pathElement((String)"transport", (String)"TRANSPORT");
    private static final PathElement lockingPath = PathElement.pathElement((String)"locking", (String)"LOCKING");
    private static final PathElement transactionPath = PathElement.pathElement((String)"transaction", (String)"TRANSACTION");
    private static final PathElement evictionPath = PathElement.pathElement((String)"eviction", (String)"EVICTION");
    private static final PathElement expirationPath = PathElement.pathElement((String)"expiration", (String)"EXPIRATION");
    private static final PathElement stateTransferPath = PathElement.pathElement((String)"state-transfer", (String)"STATE_TRANSFER");
    private static final PathElement storePath = PathElement.pathElement((String)"store", (String)"STORE");
    private static final PathElement storePropertyPath = PathElement.pathElement((String)"property");
    private static final PathElement fileStorePath = PathElement.pathElement((String)"file-store", (String)"FILE_STORE");
    private static final PathElement jdbcStorePath = PathElement.pathElement((String)"jdbc-store", (String)"JDBC_STORE");
    private static final PathElement remoteStorePath = PathElement.pathElement((String)"remote-store", (String)"REMOTE_STORE");

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, Namespace.CURRENT.getMajorVersion(), Namespace.CURRENT.getMinorVersion());
        subsystem.registerXMLElementWriter((XMLElementWriter)new InfinispanSubsystemXMLWriter());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(InfinispanSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)InfinispanSubsystemAdd.INSTANCE, InfinispanSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)InfinispanSubsystemDescribe.INSTANCE, InfinispanSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, InfinispanSubsystemProviders.SUBSYSTEM_REMOVE, false);
        ManagementResourceRegistration container = registration.registerSubModel(containerPath, InfinispanSubsystemProviders.CACHE_CONTAINER);
        container.registerOperationHandler("add", (OperationStepHandler)CacheContainerAdd.INSTANCE, InfinispanSubsystemProviders.CACHE_CONTAINER_ADD, false);
        container.registerOperationHandler("remove", (OperationStepHandler)CacheContainerRemove.INSTANCE, InfinispanSubsystemProviders.CACHE_CONTAINER_REMOVE, false);
        container.registerOperationHandler("add-alias", (OperationStepHandler)AddAliasCommand.INSTANCE, InfinispanSubsystemProviders.ADD_ALIAS, false);
        container.registerOperationHandler("remove-alias", (OperationStepHandler)RemoveAliasCommand.INSTANCE, InfinispanSubsystemProviders.REMOVE_ALIAS, false);
        CacheContainerWriteAttributeHandler.INSTANCE.registerAttributes(container);
        ManagementResourceRegistration transport = container.registerSubModel(transportPath, InfinispanSubsystemProviders.TRANSPORT);
        transport.registerOperationHandler("add", (OperationStepHandler)TransportAdd.INSTANCE, InfinispanSubsystemProviders.TRANSPORT_ADD, false);
        transport.registerOperationHandler("remove", (OperationStepHandler)TransportRemove.INSTANCE, InfinispanSubsystemProviders.TRANSPORT_REMOVE, false);
        TransportWriteAttributeHandler.INSTANCE.registerAttributes(transport);
        ManagementResourceRegistration local = container.registerSubModel(localCachePath, InfinispanSubsystemProviders.LOCAL_CACHE);
        local.registerOperationHandler("add", (OperationStepHandler)LocalCacheAdd.INSTANCE, InfinispanSubsystemProviders.LOCAL_CACHE_ADD, false);
        local.registerOperationHandler("remove", (OperationStepHandler)CacheRemove.INSTANCE, InfinispanSubsystemProviders.CACHE_REMOVE, false);
        this.registerCommonCacheAttributeHandlers(local);
        ManagementResourceRegistration invalidation = container.registerSubModel(invalidationCachePath, InfinispanSubsystemProviders.INVALIDATION_CACHE);
        invalidation.registerOperationHandler("add", (OperationStepHandler)InvalidationCacheAdd.INSTANCE, InfinispanSubsystemProviders.INVALIDATION_CACHE_ADD, false);
        invalidation.registerOperationHandler("remove", (OperationStepHandler)CacheRemove.INSTANCE, InfinispanSubsystemProviders.CACHE_REMOVE, false);
        this.registerCommonCacheAttributeHandlers(invalidation);
        this.registerClusteredCacheAttributeHandlers(invalidation);
        ManagementResourceRegistration replicated = container.registerSubModel(replicatedCachePath, InfinispanSubsystemProviders.REPLICATED_CACHE);
        replicated.registerOperationHandler("add", (OperationStepHandler)ReplicatedCacheAdd.INSTANCE, InfinispanSubsystemProviders.REPLICATED_CACHE_ADD, false);
        replicated.registerOperationHandler("remove", (OperationStepHandler)CacheRemove.INSTANCE, InfinispanSubsystemProviders.CACHE_REMOVE, false);
        this.registerCommonCacheAttributeHandlers(replicated);
        this.registerClusteredCacheAttributeHandlers(replicated);
        this.registerSharedStateCacheAttributeHandlers(replicated);
        ManagementResourceRegistration distributed = container.registerSubModel(distributedCachePath, InfinispanSubsystemProviders.DISTRIBUTED_CACHE);
        distributed.registerOperationHandler("add", (OperationStepHandler)DistributedCacheAdd.INSTANCE, InfinispanSubsystemProviders.DISTRIBUTED_CACHE_ADD, false);
        distributed.registerOperationHandler("remove", (OperationStepHandler)CacheRemove.INSTANCE, InfinispanSubsystemProviders.CACHE_REMOVE, false);
        this.registerCommonCacheAttributeHandlers(distributed);
        this.registerClusteredCacheAttributeHandlers(distributed);
        this.registerSharedStateCacheAttributeHandlers(distributed);
        CacheWriteAttributeHandler.DISTRIBUTED_CACHE_ATTR.registerAttributes(distributed);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }

    private void registerCommonCacheAttributeHandlers(ManagementResourceRegistration resource) {
        CacheWriteAttributeHandler.CACHE_ATTR.registerAttributes(resource);
        ManagementResourceRegistration locking = resource.registerSubModel(lockingPath, InfinispanSubsystemProviders.LOCKING);
        locking.registerOperationHandler("add", CacheConfigOperationHandlers.LOCKING_ADD, InfinispanSubsystemProviders.LOCKING_ADD);
        locking.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.LOCKING_REMOVE);
        CacheConfigOperationHandlers.LOCKING_ATTR.registerAttributes(locking);
        ManagementResourceRegistration transaction = resource.registerSubModel(transactionPath, InfinispanSubsystemProviders.TRANSACTION);
        transaction.registerOperationHandler("add", CacheConfigOperationHandlers.TRANSACTION_ADD, InfinispanSubsystemProviders.TRANSACTION_ADD);
        transaction.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.TRANSACTION_REMOVE);
        CacheConfigOperationHandlers.TRANSACTION_ATTR.registerAttributes(transaction);
        ManagementResourceRegistration eviction = resource.registerSubModel(evictionPath, InfinispanSubsystemProviders.EVICTION);
        eviction.registerOperationHandler("add", CacheConfigOperationHandlers.EVICTION_ADD, InfinispanSubsystemProviders.EVICTION_ADD);
        eviction.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.EVICTION_REMOVE);
        CacheConfigOperationHandlers.EVICTION_ATTR.registerAttributes(eviction);
        ManagementResourceRegistration expiration = resource.registerSubModel(expirationPath, InfinispanSubsystemProviders.EXPIRATION);
        expiration.registerOperationHandler("add", CacheConfigOperationHandlers.EXPIRATION_ADD, InfinispanSubsystemProviders.EXPIRATION_ADD);
        expiration.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.EXPIRATION_REMOVE);
        CacheConfigOperationHandlers.EXPIRATION_ATTR.registerAttributes(expiration);
        ManagementResourceRegistration store = resource.registerSubModel(storePath, InfinispanSubsystemProviders.STORE);
        store.registerOperationHandler("add", CacheConfigOperationHandlers.STORE_ADD, InfinispanSubsystemProviders.STORE_ADD);
        store.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.STORE_REMOVE);
        CacheConfigOperationHandlers.STORE_ATTR.registerAttributes(store);
        InfinispanExtension.createPropertyRegistration(store);
        ManagementResourceRegistration fileStore = resource.registerSubModel(fileStorePath, InfinispanSubsystemProviders.FILE_STORE);
        fileStore.registerOperationHandler("add", CacheConfigOperationHandlers.FILE_STORE_ADD, InfinispanSubsystemProviders.FILE_STORE_ADD);
        fileStore.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.STORE_REMOVE);
        CacheConfigOperationHandlers.FILE_STORE_ATTR.registerAttributes(fileStore);
        InfinispanExtension.createPropertyRegistration(fileStore);
        ManagementResourceRegistration jdbcStore = resource.registerSubModel(jdbcStorePath, InfinispanSubsystemProviders.JDBC_STORE);
        jdbcStore.registerOperationHandler("add", CacheConfigOperationHandlers.JDBC_STORE_ADD, InfinispanSubsystemProviders.JDBC_STORE_ADD);
        jdbcStore.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.STORE_REMOVE);
        CacheConfigOperationHandlers.JDBC_STORE_ATTR.registerAttributes(jdbcStore);
        InfinispanExtension.createPropertyRegistration(jdbcStore);
        ManagementResourceRegistration remoteStore = resource.registerSubModel(remoteStorePath, InfinispanSubsystemProviders.REMOTE_STORE);
        remoteStore.registerOperationHandler("add", CacheConfigOperationHandlers.REMOTE_STORE_ADD, InfinispanSubsystemProviders.REMOTE_STORE_ADD);
        remoteStore.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.STORE_REMOVE);
        CacheConfigOperationHandlers.REMOTE_STORE_ATTR.registerAttributes(remoteStore);
        InfinispanExtension.createPropertyRegistration(remoteStore);
    }

    private void registerClusteredCacheAttributeHandlers(ManagementResourceRegistration resource) {
        CacheWriteAttributeHandler.CLUSTERED_CACHE_ATTR.registerAttributes(resource);
    }

    private void registerSharedStateCacheAttributeHandlers(ManagementResourceRegistration resource) {
        ManagementResourceRegistration stateTransfer = resource.registerSubModel(stateTransferPath, InfinispanSubsystemProviders.STATE_TRANSFER);
        stateTransfer.registerOperationHandler("add", CacheConfigOperationHandlers.STATE_TRANSFER_ADD, InfinispanSubsystemProviders.STATE_TRANSFER_ADD);
        stateTransfer.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.STATE_TRANSFER_REMOVE);
        CacheConfigOperationHandlers.STATE_TRANSFER_ATTR.registerAttributes(stateTransfer);
    }

    static void createPropertyRegistration(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel(storePropertyPath, InfinispanSubsystemProviders.STORE_PROPERTY);
        registration.registerOperationHandler("add", CacheConfigOperationHandlers.STORE_PROPERTY_ADD, InfinispanSubsystemProviders.STORE_PROPERTY_ADD);
        registration.registerOperationHandler("remove", CacheConfigOperationHandlers.REMOVE, InfinispanSubsystemProviders.STORE_PROPERTY_REMOVE);
        registration.registerReadWriteAttribute("value", null, CacheConfigOperationHandlers.STORE_PROPERTY_ATTR, EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES));
    }
}

