/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.group;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.distribution.group.Group;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;

public class GroupManagerImpl
implements GroupManager {
    private final ConcurrentMap<Class<?>, GroupMetadata> groupMetadataCache = new ConcurrentHashMap();
    private final List<Grouper<?>> groupers;

    private static GroupMetadata createGroupMetadata(Class<?> clazz) {
        List<Method> possibleMethods = ReflectionUtil.getAllMethods(clazz, Group.class);
        if (possibleMethods.isEmpty()) {
            return GroupMetadata.NONE;
        }
        if (possibleMethods.size() == 1) {
            return new GroupMetadataImpl((Method)possibleMethods.iterator().next());
        }
        throw new IllegalStateException(Util.formatString("Cannot define more that one @Group method for class hierarchy rooted at %s", clazz.getName()));
    }

    public GroupManagerImpl(List<Grouper<?>> groupers) {
        this.groupers = groupers != null ? groupers : Collections.emptyList();
    }

    @Override
    public String getGroup(Object key) {
        GroupMetadata metadata = this.getMetadata(key);
        if (metadata != null) {
            return this.applyGroupers(metadata.getGroup(key), key);
        }
        return this.applyGroupers(null, key);
    }

    private String applyGroupers(String group, Object key) {
        for (Grouper<?> grouper : this.groupers) {
            if (!grouper.getKeyType().isAssignableFrom(key.getClass())) continue;
            group = grouper.computeGroup(key, group);
        }
        return group;
    }

    private GroupMetadata getMetadata(Object key) {
        GroupMetadata previous;
        Class<?> keyClass = key.getClass();
        GroupMetadata groupMetadata = (GroupMetadata)this.groupMetadataCache.get(keyClass);
        if (groupMetadata == null && (previous = this.groupMetadataCache.putIfAbsent(keyClass, groupMetadata = GroupManagerImpl.createGroupMetadata(keyClass))) != null) {
            return previous;
        }
        return groupMetadata;
    }

    private static class GroupMetadataImpl
    implements GroupMetadata {
        private final Method method;

        public GroupMetadataImpl(Method method) {
            if (!String.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException(Util.formatString("@Group method %s must return java.lang.String", method));
            }
            if (method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException(Util.formatString("@Group method %s must jave zero arguments", method));
            }
            this.method = method;
        }

        @Override
        public String getGroup(Object instance) {
            return (String)String.class.cast(ReflectionUtil.invokeAccessibly(instance, this.method, Util.EMPTY_OBJECT_ARRAY));
        }
    }

    private static interface GroupMetadata {
        public static final GroupMetadata NONE = new GroupMetadata(){

            @Override
            public String getGroup(Object instance) {
                return null;
            }
        };

        public String getGroup(Object var1);
    }
}

