/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class OSGiTestHelper {
    private static final Logger log = Logger.getLogger(OSGiTestHelper.class);
    public static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    public static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static String testResourcesDir = System.getProperty("test.resources.directory", "target/test-classes");
    private static String testArchiveDir = System.getProperty("test.archive.directory", "target/test-libs");

    private OSGiTestHelper() {
    }

    public static URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = OSGiTestHelper.getResourceFile(resource);
            resURL = resourceFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public static File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(testResourcesDir + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testResourcesDir + "/" + resource + "'");
    }

    public static URL getTestArchiveURL(String archive) {
        try {
            URL archiveURL = new URL(archive);
            return archiveURL;
        }
        catch (MalformedURLException ex) {
            try {
                File file = OSGiTestHelper.getTestArchiveFile(archive);
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new IllegalStateException(ex2);
            }
        }
    }

    public static String getTestArchivePath(String archive) {
        File archiveFile = OSGiTestHelper.getTestArchiveFile(archive);
        return archiveFile.getAbsolutePath();
    }

    public static File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(testArchiveDir + "/" + archive);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testArchiveDir + "/" + archive + "'.");
    }

    public static String getServerHost() {
        String bindAddress = System.getProperty("jboss.bind.address", "localhost");
        return bindAddress;
    }

    public static String getTargetContainer() {
        String targetContainer = System.getProperty("target.container");
        return targetContainer;
    }

    public static String getFrameworkName() {
        String framework = System.getProperty("framework");
        if (framework == null || framework.length() == 0 || framework.equals("${framework}")) {
            framework = "jbossmsc";
        }
        return framework;
    }

    public static JavaArchive assembleArchive(String name, String resource, Class<?> ... packages) throws Exception {
        return OSGiTestHelper.assembleArchive(name, new String[]{resource}, packages);
    }

    public static JavaArchive assembleArchive(String name, String[] resources, Class<?> ... packages) throws IOException {
        URL url;
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(name + ".jar"));
        if (resources != null) {
            for (String res : resources) {
                url = OSGiTestHelper.class.getResource(res);
                if (url == null) {
                    throw new IllegalArgumentException("Cannot load resource: " + (String)res);
                }
                VirtualFile file = AbstractVFS.toVirtualFile((URL)url);
                if (file.isDirectory()) {
                    OSGiTestHelper.addResources(archive, file, file);
                    continue;
                }
                OSGiTestHelper.addResource(archive, res, file);
            }
        }
        if (packages != null) {
            for (Class<?> clazz : packages) {
                url = clazz.getResource("/");
                VirtualFile base = AbstractVFS.toVirtualFile((URL)url);
                String path = clazz.getName().replace('.', '/');
                path = path.substring(0, path.lastIndexOf("/"));
                VirtualFile classes = base.getChild(path);
                OSGiTestHelper.addResources(archive, base, classes);
            }
        }
        return archive;
    }

    public static VirtualFile toVirtualFile(Archive<?> archive) throws IOException, MalformedURLException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        return AbstractVFS.toVirtualFile((String)archive.getName(), (InputStream)exporter.exportAsInputStream());
    }

    public static InputStream toInputStream(Archive<?> archive) throws IOException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        return exporter.exportAsInputStream();
    }

    private static void addResources(JavaArchive archive, VirtualFile basedir, VirtualFile resdir) throws IOException {
        String basepath = basedir.getPathName();
        for (VirtualFile child : resdir.getChildrenRecursively()) {
            if (child.isDirectory()) continue;
            String path = child.getPathName();
            path = path.substring(basepath.length());
            OSGiTestHelper.addResource(archive, path, child);
        }
    }

    private static void addResource(JavaArchive archive, String path, final VirtualFile file) {
        Asset asset = new Asset(){

            public InputStream openStream() {
                try {
                    return file.openStream();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot open stream for: " + file, ex);
                }
            }
        };
        archive.add(asset, path);
    }

    public static void assertBundleState(int expState, int wasState) {
        String expstr = ConstantsHelper.bundleState(expState);
        String wasstr = ConstantsHelper.bundleState(wasState);
        Assert.assertEquals((String)("Bundle " + expstr), (Object)expstr, (Object)wasstr);
    }

    public static Class<?> assertLoadClass(Bundle bundle, String className) {
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            String message = "Unexpected ClassNotFoundException for: " + bundle.getSymbolicName() + " loads " + className;
            log.error((Object)message, (Throwable)ex);
            Assert.fail((String)message);
            return null;
        }
    }

    public static void assertLoadClassFail(Bundle bundle, String className) {
        try {
            Class clazz = bundle.loadClass(className);
            String message = bundle.getSymbolicName() + " loads " + className;
            Assert.fail((String)("ClassNotFoundException expected for: " + message + "\nLoaded from " + clazz.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void assertLoadClass(Bundle bundle, String className, Bundle exporter) {
        Class<?> importerClazz = OSGiTestHelper.assertLoadClass(bundle, className);
        Class<?> exporterClazz = OSGiTestHelper.assertLoadClass(exporter, className);
        Assert.assertEquals((String)"Loaded from ClassLoader", (Object)exporterClazz.getClassLoader(), (Object)importerClazz.getClassLoader());
    }
}

