/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class AsynchronousService<T>
implements Service<T> {
    private final Executor executor = Executors.newCachedThreadPool();
    private final boolean startAsynchronously;
    private final boolean stopAsynchronously;

    protected AsynchronousService() {
        this(true, true);
    }

    protected AsynchronousService(boolean startAsynchronously, boolean stopAsynchronously) {
        this.startAsynchronously = startAsynchronously;
        this.stopAsynchronously = stopAsynchronously;
    }

    public void start(final StartContext context) throws StartException {
        if (this.startAsynchronously) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        AsynchronousService.this.start();
                        context.complete();
                    }
                    catch (Exception e) {
                        context.failed(new StartException((Throwable)e));
                    }
                }
            };
            context.asynchronous();
            this.executor.execute(task);
        } else {
            try {
                this.start();
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
        }
    }

    public void stop(final StopContext context) {
        if (this.stopAsynchronously) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AsynchronousService.this.stop();
                    }
                    finally {
                        context.complete();
                    }
                }
            };
            context.asynchronous();
            this.executor.execute(task);
        } else {
            this.stop();
        }
    }

    protected abstract void start() throws Exception;

    protected abstract void stop();
}

