/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.ejb.EjbRequestScopeActivationInterceptor;
import org.jboss.as.weld.ejb.Jsr299BindingsInterceptor;
import org.jboss.as.weld.injection.WeldInjectionInterceptor;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.as.weld.services.WeldService;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class WeldComponentIntegrationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final ServiceName weldServiceName = topLevelDeployment.getServiceName().append(WeldService.SERVICE_NAME);
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            final String beanName = component instanceof EJBComponentDescription ? component.getComponentName() : null;
            component.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    Class componentClass = configuration.getComponentClass();
                    DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                    ModuleClassLoader classLoader = ((Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader();
                    HashSet interceptorClasses = new HashSet();
                    for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                        try {
                            ClassIndex index = classIndex.classIndex(interceptorDescription.getInterceptorClassName());
                            interceptorClasses.add(index.getModuleClass());
                        }
                        catch (ClassNotFoundException e) {
                            throw WeldMessages.MESSAGES.couldNotLoadInterceptorClass(interceptorDescription.getInterceptorClassName(), e);
                        }
                    }
                    WeldComponentIntegrationProcessor.this.addWeldIntegration(context.getServiceTarget(), configuration, description, componentClass, beanName, weldServiceName, interceptorClasses, (ClassLoader)classLoader, description.getBeanDeploymentArchiveId());
                    configuration.addPostConstructInterceptor((InterceptorFactory)new WeldInjectionInterceptor.Factory(configuration, interceptorClasses), 2304);
                    if (description instanceof StatefulComponentDescription) {
                        configuration.getInterceptorContextKeys().add(InterceptionType.AROUND_INVOKE);
                        configuration.getInterceptorContextKeys().add(InterceptionType.AROUND_TIMEOUT);
                        configuration.getInterceptorContextKeys().add(InterceptionType.POST_ACTIVATE);
                        configuration.getInterceptorContextKeys().add(InterceptionType.POST_CONSTRUCT);
                        configuration.getInterceptorContextKeys().add(InterceptionType.PRE_DESTROY);
                        configuration.getInterceptorContextKeys().add(InterceptionType.PRE_PASSIVATE);
                    }
                }
            });
        }
    }

    private void addWeldIntegration(ServiceTarget target, ComponentConfiguration configuration, ComponentDescription description, Class<?> componentClass, String beanName, ServiceName weldServiceName, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId) {
        final ServiceName serviceName = configuration.getComponentDescription().getServiceName().append(new String[]{"WeldInstantiator"});
        WeldManagedReferenceFactory factory = new WeldManagedReferenceFactory(componentClass, beanName, interceptorClasses, classLoader, beanDeploymentArchiveId);
        ServiceBuilder builder = target.addService(serviceName, (Service)factory).addDependency(weldServiceName, WeldContainer.class, factory.getWeldContainer());
        configuration.setInstanceFactory((ManagedReferenceFactory)factory);
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                serviceBuilder.addDependency(serviceName);
            }
        });
        if (description instanceof EJBComponentDescription) {
            EjbRequestScopeActivationInterceptor.Factory requestFactory = new EjbRequestScopeActivationInterceptor.Factory(classLoader, weldServiceName, description instanceof MessageDrivenComponentDescription);
            configuration.addComponentInterceptor((InterceptorFactory)requestFactory, 800, false);
            Jsr299BindingsInterceptor.Factory aroundInvokeFactory = new Jsr299BindingsInterceptor.Factory(description.getBeanDeploymentArchiveId(), beanName, InterceptionType.AROUND_INVOKE, classLoader);
            Jsr299BindingsInterceptor.Factory aroundTimeoutFactory = new Jsr299BindingsInterceptor.Factory(description.getBeanDeploymentArchiveId(), beanName, InterceptionType.AROUND_TIMEOUT, classLoader);
            builder.addDependency(weldServiceName, WeldContainer.class, aroundTimeoutFactory.getWeldContainer());
            builder.addDependency(weldServiceName, WeldContainer.class, aroundInvokeFactory.getWeldContainer());
            configuration.addComponentInterceptor((InterceptorFactory)new UserInterceptorFactory((InterceptorFactory)aroundInvokeFactory, (InterceptorFactory)aroundTimeoutFactory), 2816, false);
            Jsr299BindingsInterceptor.Factory preDestroyInterceptor = new Jsr299BindingsInterceptor.Factory(description.getBeanDeploymentArchiveId(), beanName, InterceptionType.PRE_DESTROY, classLoader);
            builder.addDependency(weldServiceName, WeldContainer.class, preDestroyInterceptor.getWeldContainer());
            configuration.addPreDestroyInterceptor((InterceptorFactory)preDestroyInterceptor, 2304);
            if (description.isPassivationApplicable()) {
                Jsr299BindingsInterceptor.Factory prePassivateInterceptor = new Jsr299BindingsInterceptor.Factory(description.getBeanDeploymentArchiveId(), beanName, InterceptionType.PRE_PASSIVATE, classLoader);
                builder.addDependency(weldServiceName, WeldContainer.class, prePassivateInterceptor.getWeldContainer());
                configuration.addPrePassivateInterceptor((InterceptorFactory)prePassivateInterceptor, 2304);
                Jsr299BindingsInterceptor.Factory postActivateInterceptor = new Jsr299BindingsInterceptor.Factory(description.getBeanDeploymentArchiveId(), beanName, InterceptionType.POST_ACTIVATE, classLoader);
                builder.addDependency(weldServiceName, WeldContainer.class, postActivateInterceptor.getWeldContainer());
                configuration.addPostActivateInterceptor((InterceptorFactory)postActivateInterceptor, 2304);
            }
            Jsr299BindingsInterceptor.Factory postConstruct = new Jsr299BindingsInterceptor.Factory(description.getBeanDeploymentArchiveId(), beanName, InterceptionType.POST_CONSTRUCT, classLoader);
            builder.addDependency(weldServiceName, WeldContainer.class, postConstruct.getWeldContainer());
            configuration.addPostConstructInterceptor((InterceptorFactory)postConstruct, 3072);
        }
        builder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

