/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String EXCEPTION_HANDLER_FACTORY = "javax.faces.context.ExceptionHandlerFactory";
    public static final String EXTERNAL_CONTEXT_FACTORY = "javax.faces.context.ExternalContextFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String FACELET_CACHE_FACTORY = "javax.faces.view.facelets.FaceletCacheFactory";
    public static final String PARTIAL_VIEW_CONTEXT_FACTORY = "javax.faces.context.PartialViewContextFactory";
    public static final String VISIT_CONTEXT_FACTORY = "javax.faces.component.visit.VisitContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    public static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "javax.faces.view.ViewDeclarationLanguageFactory";
    public static final String TAG_HANDLER_DELEGATE_FACTORY = "javax.faces.view.facelets.TagHandlerDelegateFactory";
    private static final FactoryManagerCache FACTORIES_CACHE = new FactoryManagerCache();
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory"};
    private static Map<String, Class> factoryClasses = null;
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        FactoryFinder.validateFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager manager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        return manager.getFactory(classLoader, factoryName);
    }

    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.validateFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager manager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        manager.addFactory(factoryName, implName);
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader cl = FactoryFinder.getClassLoader();
        FACTORIES_CACHE.removeApplicationFactoryManager(cl);
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        List<String> fromServices;
        String curImplClass;
        int len;
        Object result = null;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if ((fromServices = FactoryFinder.getImplNameFromServices(classLoader, factoryName)) != null) {
            for (String name : fromServices) {
                result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, name, result);
            }
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        ArrayList<String> result;
        block12: {
            result = null;
            String resourceName = "META-INF/services/" + factoryName;
            BufferedReader reader = null;
            try {
                Enumeration<URL> e = classLoader.getResources(resourceName);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream stream = conn.getInputStream();
                    if (stream == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                        if (result == null) {
                            result = new ArrayList<String>(3);
                        }
                        result.add(reader.readLine());
                    }
                    catch (UnsupportedEncodingException uee) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                            reader = null;
                        }
                        if (stream == null) continue;
                        stream.close();
                        stream = null;
                    }
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (SecurityException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return result;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz;
        Class factoryClass = null;
        Object[] newInstanceArgs = new Object[1];
        Object result = null;
        if (null != previousImpl && null != (factoryClass = FactoryFinder.getFactoryClass(factoryName))) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                Class[] getCtorArg = new Class[]{factoryClass};
                Constructor<?> ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        return result;
    }

    private static Class getFactoryClass(String factoryClassName) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap<String, Class>(FACTORY_NAMES.length);
            factoryClasses.put(APPLICATION_FACTORY, ApplicationFactory.class);
            factoryClasses.put(EXCEPTION_HANDLER_FACTORY, ExceptionHandlerFactory.class);
            factoryClasses.put(EXTERNAL_CONTEXT_FACTORY, ExternalContextFactory.class);
            factoryClasses.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
            factoryClasses.put(VISIT_CONTEXT_FACTORY, VisitContextFactory.class);
            factoryClasses.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
            factoryClasses.put(PARTIAL_VIEW_CONTEXT_FACTORY, PartialViewContextFactory.class);
            factoryClasses.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
            factoryClasses.put(VIEW_DECLARATION_LANGUAGE_FACTORY, ViewDeclarationLanguageFactory.class);
            factoryClasses.put(TAG_HANDLER_DELEGATE_FACTORY, TagHandlerDelegateFactory.class);
        }
        return factoryClasses.get(factoryClassName);
    }

    private static void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, factoryName) < 0) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    private static void reInitializeFactoryManager() {
        FACTORIES_CACHE.resetSpecialInitializationCaseFlags();
    }

    static {
        Arrays.sort(FACTORY_NAMES);
    }

    private static final class FactoryManager {
        private final Map<String, Object> factories;
        private final Map<String, List<String>> savedFactoryNames;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

        public FactoryManager() {
            this.factories = new HashMap<String, Object>();
            this.savedFactoryNames = new HashMap<String, List<String>>();
            for (String name : FACTORY_NAMES) {
                this.factories.put(name, new ArrayList(4));
            }
        }

        public FactoryManager(FactoryManager toCopy) {
            this.factories = new HashMap<String, Object>();
            this.savedFactoryNames = new HashMap<String, List<String>>();
            this.factories.putAll(toCopy.savedFactoryNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFactory(String factoryName, String implementation) {
            Object result = this.factories.get(factoryName);
            this.lock.writeLock().lock();
            try {
                if (result instanceof List) {
                    TypedCollections.dynamicallyCastList((List)result, String.class).add(0, implementation);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFactory(ClassLoader cl, String factoryName) {
            Object factoryOrList;
            this.lock.readLock().lock();
            try {
                factoryOrList = this.factories.get(factoryName);
                if (!(factoryOrList instanceof List)) {
                    Object object = factoryOrList;
                    return object;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                factoryOrList = this.factories.get(factoryName);
                if (!(factoryOrList instanceof List)) {
                    Object object = factoryOrList;
                    return object;
                }
                this.savedFactoryNames.put(factoryName, new ArrayList((List)factoryOrList));
                Object factory = FactoryFinder.getImplementationInstance(cl, factoryName, (List)factoryOrList);
                if (factory == null) {
                    ResourceBundle rb = LOGGER.getResourceBundle();
                    String message = rb.getString("severe.no_factory");
                    message = MessageFormat.format(message, factoryName);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, message);
                    }
                    if (null == (factory = FACTORIES_CACHE.getFallbackFactory(cl, this, factoryName))) {
                        message = rb.getString("severe.no_factory_backup_failed");
                        message = MessageFormat.format(message, factoryName);
                        throw new IllegalStateException(message);
                    }
                }
                this.factories.put(factoryName, factory);
                Object object = factory;
                return object;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static final class FactoryManagerCacheKey {
        private ClassLoader cl;
        private Long marker;
        private Object context;
        private static final String KEY = FactoryFinder.class.getName() + "." + FactoryManagerCacheKey.class.getSimpleName();

        public FactoryManagerCacheKey(FacesContext facesContext, ClassLoader cl, Map<FactoryManagerCacheKey, FactoryManager> factoryMap) {
            this.cl = cl;
            boolean resolveValueFromFactoryMap = false;
            if (null == facesContext) {
                resolveValueFromFactoryMap = true;
            } else {
                ExternalContext extContext = facesContext.getExternalContext();
                this.context = extContext.getContext();
                if (null == this.context) {
                    resolveValueFromFactoryMap = true;
                } else {
                    Map<String, Object> appMap = extContext.getApplicationMap();
                    Long val = (Long)appMap.get(KEY);
                    if (null == val) {
                        this.marker = new Long(System.currentTimeMillis());
                        appMap.put(KEY, this.marker);
                    } else {
                        this.marker = val;
                    }
                }
            }
            if (resolveValueFromFactoryMap) {
                Set<FactoryManagerCacheKey> keys = factoryMap.keySet();
                FactoryManagerCacheKey match = null;
                for (FactoryManagerCacheKey cur : keys) {
                    if (!this.cl.equals(cur.cl)) continue;
                    if (null != cur && null != match) {
                        LOGGER.log(Level.WARNING, "Multiple JSF Applications found on same ClassLoader.  Unable to safely determine which FactoryManager instance to use. Defaulting to first match.");
                        break;
                    }
                    match = cur;
                }
                if (null != match) {
                    this.marker = match.marker;
                }
            }
        }

        public ClassLoader getClassLoader() {
            return this.cl;
        }

        public Object getContext() {
            return this.context;
        }

        private FactoryManagerCacheKey() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FactoryManagerCacheKey other = (FactoryManagerCacheKey)obj;
            if (!(this.cl == other.cl || this.cl != null && this.cl.equals(other.cl))) {
                return false;
            }
            return this.marker == other.marker || this.marker != null && this.marker.equals(other.marker);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.cl != null ? this.cl.hashCode() : 0);
            hash = 97 * hash + (this.marker != null ? this.marker.hashCode() : 0);
            return hash;
        }
    }

    private static final class FactoryManagerCache {
        private ConcurrentMap<FactoryManagerCacheKey, FactoryManager> applicationMap = new ConcurrentHashMap<FactoryManagerCacheKey, FactoryManager>();
        private AtomicBoolean logNullFacesContext = new AtomicBoolean(false);
        private AtomicBoolean logNonNullFacesContext = new AtomicBoolean(false);

        private FactoryManagerCache() {
        }

        private Object getFallbackFactory(ClassLoader cl, FactoryManager brokenFactoryManager, String factoryName) {
            Object result = null;
            for (Map.Entry cur : this.applicationMap.entrySet()) {
                if (((FactoryManagerCacheKey)cur.getKey()).getClassLoader().equals(cl) && !((FactoryManager)cur.getValue()).equals(brokenFactoryManager) && null != (result = ((FactoryManager)cur.getValue()).getFactory(cl, factoryName))) break;
            }
            return result;
        }

        private FactoryManager getApplicationFactoryManager(ClassLoader cl) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            boolean isSpecialInitializationCase = this.detectSpecialInitializationCase(facesContext);
            FactoryManagerCacheKey key = new FactoryManagerCacheKey(facesContext, cl, this.applicationMap);
            FactoryManager result = (FactoryManager)this.applicationMap.get(key);
            FactoryManager toCopy = null;
            if (result == null) {
                boolean createNewFactoryManagerInstance = false;
                if (isSpecialInitializationCase) {
                    boolean classLoadersMatchButContextsDoNotMatch = false;
                    boolean foundNoMatchInApplicationMap = true;
                    for (Map.Entry cur : this.applicationMap.entrySet()) {
                        FactoryManagerCacheKey curKey = (FactoryManagerCacheKey)cur.getKey();
                        if (!curKey.getClassLoader().equals(cl)) continue;
                        foundNoMatchInApplicationMap = false;
                        if (null != key.getContext() && null != curKey.getContext() && !key.getContext().equals(curKey.getContext())) {
                            classLoadersMatchButContextsDoNotMatch = true;
                            toCopy = (FactoryManager)cur.getValue();
                            break;
                        }
                        result = (FactoryManager)cur.getValue();
                        break;
                    }
                    createNewFactoryManagerInstance = foundNoMatchInApplicationMap || null == result && classLoadersMatchButContextsDoNotMatch;
                } else {
                    createNewFactoryManagerInstance = true;
                }
                if (createNewFactoryManagerInstance) {
                    FactoryManager newResult = null != toCopy ? new FactoryManager(toCopy) : new FactoryManager();
                    result = this.applicationMap.putIfAbsent(key, newResult);
                    result = null != result ? result : newResult;
                }
            }
            return result;
        }

        private boolean detectSpecialInitializationCase(FacesContext facesContext) {
            boolean result = false;
            if (null == facesContext) {
                this.logNullFacesContext.compareAndSet(false, true);
            } else {
                this.logNonNullFacesContext.compareAndSet(false, true);
            }
            result = this.logNullFacesContext.get() && this.logNonNullFacesContext.get();
            return result;
        }

        public void removeApplicationFactoryManager(ClassLoader cl) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            boolean isSpecialInitializationCase = this.detectSpecialInitializationCase(facesContext);
            FactoryManagerCacheKey key = new FactoryManagerCacheKey(facesContext, cl, this.applicationMap);
            this.applicationMap.remove(key);
            if (isSpecialInitializationCase) {
                this.logNullFacesContext.set(false);
                this.logNonNullFacesContext.set(false);
            }
        }

        public void resetSpecialInitializationCaseFlags() {
            this.logNullFacesContext.set(false);
            this.logNonNullFacesContext.set(false);
        }
    }
}

