/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class PassivationStoreWriteHandler<S extends BackingCacheEntryStoreConfig>
extends AbstractWriteAttributeHandler<Void> {
    PassivationStoreWriteHandler(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyModelToRuntime(context, operation, attributeName, model);
        return false;
    }

    private void applyModelToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode model) throws OperationFailedException {
        BackingCacheEntryStoreConfig config;
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = BackingCacheEntryStoreSourceService.getServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName);
        if (service != null && (config = (BackingCacheEntryStoreConfig)service.getValue()) != null) {
            AttributeDefinition maxSizeDefinition = this.getMaxSizeDefinition();
            if (maxSizeDefinition.getName().equals(attributeName)) {
                int maxSize = maxSizeDefinition.resolveModelAttribute(context, model).asInt();
                config.setMaxSize(maxSize);
            } else if (PassivationStoreResourceDefinition.IDLE_TIMEOUT.getName().equals(attributeName)) {
                long timeout = PassivationStoreResourceDefinition.IDLE_TIMEOUT.resolveModelAttribute(context, model).asLong();
                config.setIdleTimeout(timeout);
            } else if (PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.getName().equals(attributeName)) {
                TimeUnit unit = TimeUnit.valueOf(PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.resolveModelAttribute(context, model).asString());
                config.setIdleTimeoutUnit(unit);
            } else {
                this.apply(config, context, attributeName, model);
            }
        }
    }

    protected abstract AttributeDefinition getMaxSizeDefinition();

    protected abstract void apply(S var1, OperationContext var2, String var3, ModelNode var4) throws OperationFailedException;

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(context, operation, attributeName, restored);
    }
}

