/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.net.URISyntaxException;
import java.util.jar.Attributes;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jboss.modules.ModuleIdentifier;

@MessageLogger(projectCode="JBAS")
public interface ServerLogger
extends BasicLogger {
    public static final ServerLogger ROOT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)ServerLogger.class.getPackage().getName());
    public static final ServerLogger AS_ROOT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as");
    public static final ServerLogger CONFIG_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.config");
    public static final ServerLogger DEPLOYMENT_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server.deployment");
    public static final ServerLogger PRIVATE_DEP_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.dependency.private");
    public static final ServerLogger UNSUPPORTED_DEP_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.dependency.unsupported");
    public static final ServerLogger MODULE_SERVICE_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server.moduleservice");
    public static final ServerLogger NETWORK_LOGGER = (ServerLogger)Logger.getMessageLogger(ServerLogger.class, (String)"org.jboss.as.server.net");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15850, value="%s in subdeployment ignored. jboss-deployment-structure.xml is only parsed for top level deployments.")
    public void jbossDeploymentStructureIgnored(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15851, value="Could not read provided index: %s")
    public void cannotLoadAnnotationIndex(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15852, value="Could not index class %s at %s")
    public void cannotIndexClass(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15853, value="More than two unique criteria addresses were seen: %s")
    public void moreThanTwoUniqueCriteria(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15854, value="Checking two unique criteria addresses were seen: %s")
    public void checkingTwoUniqueCriteria(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15855, value="Two unique criteria addresses were seen: %s")
    public void twoUniqueCriteriaAddresses(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15856, value="Undeploy of deployment \"%s\" was rolled back with failure message %s")
    public void undeploymentRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15857, value="Undeploy of deployment \"%s\" was rolled back with no failure message")
    public void undeploymentRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18558, value="Undeployed \"%s\"")
    public void deploymentUndeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18559, value="Deployed \"%s\"")
    public void deploymentDeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15860, value="Redeploy of deployment \"%s\" was rolled back with failure message %s")
    public void redeployRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15861, value="Redeploy of deployment \"%s\" was rolled back with no failure message")
    public void redeployRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18562, value="Redeployed \"%s\"")
    public void deploymentRedeployed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15863, value="Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with failure message %s")
    public void replaceRolledBack(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15864, value="Replacement of deployment \"%s\" by deployment \"%s\" was rolled back with no failure message")
    public void replaceRolledBackWithNoMessage(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18565, value="Replaced deployment \"%s\" with deployment \"%s\"")
    public void deploymentReplaced(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18566, value="Annotations import option %s specified in jboss-deployment-structure.xml for additional module %s has been ignored. Additional modules cannot import annotations.")
    public void annotationImportIgnored(ModuleIdentifier var1, ModuleIdentifier var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18567, value="Deployment \"%s\" is using a private module (\"%s\") which may be changed or removed in future versions without notice.")
    public void privateApiUsed(String var1, ModuleIdentifier var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18568, value="Deployment \"%s\" is using an unsupported module (\"%s\") which may be changed or removed in future versions without notice.")
    public void unsupportedApiUsed(String var1, ModuleIdentifier var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18569, value="Exception occurred removing deployment content %s")
    public void failedToRemoveDeploymentContent(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15870, value="Deploy of deployment \"%s\" was rolled back with failure message %s")
    public void deploymentRolledBack(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15871, value="Deploy of deployment \"%s\" was rolled back with no failure message")
    public void deploymentRolledBackWithNoMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15872, value="Failed to parse property (%s), value (%s) as an integer")
    public void failedToParseCommandLineInteger(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15873, value="Cannot add module '%s' as URLStreamHandlerFactory provider")
    public void cannotAddURLStreamHandlerFactory(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15874, value="%s started in %dms - Started %d of %d services (%d services are passive or on-demand)")
    public void startedClean(String var1, long var2, int var4, int var5, int var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15875, value="%s started (with errors) in %dms - Started %d of %d services (%d services failed or missing dependencies, %d services are passive or on-demand)")
    public void startedWitErrors(String var1, long var2, int var4, int var5, int var6, int var7);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15876, value="Starting deployment of \"%s\"")
    public void startingDeployment(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15877, value="Stopped deployment %s in %dms")
    public void stoppedDeployment(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15878, value="Deployment '%s' started successfully")
    public void deploymentStarted(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15879, value="Deployment '%s' has failed services\n    Failed services: %s")
    public void deploymentHasFailedServices(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15880, value="Deployment '%s' has services missing dependencies\n    Missing dependencies: %s")
    public void deploymentHasMissingDependencies(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15881, value="Deployment '%s' has failed services and services missing dependencies\n    Failed services: %s\n    Missing dependencies: %s")
    public void deploymentHasMissingAndFailedServices(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15882, value="%s caught exception attempting to revert operation %s at address %s")
    public void caughtExceptionRevertingOperation(@Cause Exception var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15883, value="No security realm defined for native management service; all access will be unrestricted.")
    public void nativeManagementInterfaceIsUnsecured();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15884, value="No security realm defined for http management service; all access will be unrestricted.")
    public void httpManagementInterfaceIsUnsecured();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15885, value="Creating http management service using network interface (%s) and port (%d)")
    public void creatingHttpManagementServiceOnPort(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15886, value="Creating http management service using network interface (%s) and secure port (%d)")
    public void creatingHttpManagementServiceOnSecurePort(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15887, value="Creating http management service using network interface (%s), port (%d) and secure port (%d)")
    public void creatingHttpManagementServiceOnPortAndSecurePort(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15888, value="Creating http management service using socket-binding (%s)")
    public void creatingHttpManagementServiceOnSocket(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15889, value="Creating http management service using secure-socket-binding (%s)")
    public void creatingHttpManagementServiceOnSecureSocket(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15890, value="Creating http management service using socket-binding (%s) and secure-socket-binding (%s)")
    public void creatingHttpManagementServiceOnSocketAndSecureSocket(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15891, value="Caught exception closing input stream for uploaded deployment content")
    public void caughtExceptionClosingContentInputStream(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15892, value="Deployment unit processor %s unexpectedly threw an exception during undeploy phase %s of %s")
    public void caughtExceptionUndeploying(@Cause Throwable var1, DeploymentUnitProcessor var2, Phase var3, DeploymentUnit var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15893, value="Encountered invalid class name '%s' for service type '%s'")
    public void invalidServiceClassName(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15894, value="Module %s will not have it's annotations processed as no %s file was found in the deployment. Please generate this file using the Jandex ant task.")
    public void noCompositeIndex(ModuleIdentifier var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15895, value="Extension %s is missing the required manifest attribute %s-%s (skipping extension)")
    public void extensionMissingManifestAttribute(String var1, String var2, Attributes.Name var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15896, value="Extension %s URI syntax is invalid: %s")
    public void invalidExtensionURI(String var1, URISyntaxException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15897, value="Could not find Extension-List entry %s referenced from %s")
    public void cannotFindExtensionListEntry(ExtensionListEntry var1, ResourceRoot var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15898, value="A server name configuration was provided both via system propert %s ('%s') and via the xml configuration ('%s'). The xml configuration valid will be used.")
    public void duplicateServerNameConfiguration(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15899, value="%s starting")
    public void serverStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15950, value="%s stopped in %dms")
    public void serverStopped(String var1, int var2);
}

