/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class DeploymentRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    private final ContentRepository contentRepository;

    public DeploymentRemoveHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final List<byte[]> removedHashes = DeploymentUtils.getDeploymentHash(resource);
        final Resource deployment = context.removeResource(PathAddress.EMPTY_ADDRESS);
        final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
        final ModelNode model = deployment.getModel();
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    block8: {
                        boolean enabled;
                        String deploymentUnitName;
                        block6: {
                            block7: {
                                deploymentUnitName = null;
                                boolean bl = enabled = !model.hasDefined("enabled") || model.get("enabled").asBoolean();
                                if (enabled) {
                                    String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
                                    deploymentUnitName = model.hasDefined("runtime-name") ? model.get("runtime-name").asString() : name;
                                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                                    context.removeService(deploymentUnitServiceName);
                                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                                }
                                if (context.completeStep() != OperationContext.ResultAction.ROLLBACK) break block6;
                                if (enabled) {
                                    DeploymentRemoveHandler.this.recoverServices(context, model, deployment, registration, mutableRegistration);
                                }
                                if (!enabled || !context.hasFailureDescription()) break block7;
                                ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                break block8;
                            }
                            if (!enabled) break block8;
                            ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                            break block8;
                        }
                        if (enabled) {
                            ServerLogger.ROOT_LOGGER.deploymentUndeployed(deploymentUnitName);
                        }
                        for (byte[] hash : removedHashes) {
                            try {
                                DeploymentRemoveHandler.this.contentRepository.removeContent(hash);
                            }
                            catch (Exception e) {
                                ServerLogger.DEPLOYMENT_LOGGER.failedToRemoveDeploymentContent(e, HashUtil.bytesToHexString((byte[])hash));
                            }
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return ServerDescriptions.getRemoveDeploymentOperation(locale);
    }

    private void recoverServices(OperationContext context, ModelNode model, Resource deployment, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration) {
        String name = model.require("name").asString();
        String runtimeName = model.hasDefined("runtime-name") ? model.get("runtime-name").asString() : name;
        DeploymentHandlerUtil.ContentItem[] contents = AbstractDeploymentHandler.getContents(model.require("content"));
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        DeploymentHandlerUtil.doDeploy(context, runtimeName, name, verificationHandler, deployment, registration, mutableRegistration, contents);
    }
}

