/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterListProxies
implements OperationStepHandler,
DescriptionProvider {
    static final ModClusterListProxies INSTANCE = new ModClusterListProxies();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getListProxiesDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    ModCluster modcluster = (ModCluster)controller.getValue();
                    Map<InetSocketAddress, String> map = modcluster.getProxyInfo();
                    ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ListProxies %s", map);
                    if (!map.isEmpty()) {
                        ModelNode result = new ModelNode();
                        Object[] addr = map.keySet().toArray();
                        for (int i = 0; i < addr.length; ++i) {
                            InetSocketAddress address = (InetSocketAddress)addr[i];
                            result.add(address.getHostName() + ":" + address.getPort());
                        }
                        context.getResult().set(result);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

