/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client.cache;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.protocol.IoFutureHelper;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class ConnectionCache {
    private static final Logger logger = Logger.getLogger(ConnectionCache.class);
    private final ConcurrentMap<CacheKey, CacheEntry> cache = new ConcurrentHashMap<CacheKey, CacheEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection get(Endpoint clientEndpoint, URI connectionURI, OptionMap connectOptions, CallbackHandler callbackHandler, long connectionTimeout) throws IOException {
        CacheKey key = new CacheKey(callbackHandler.getClass(), connectOptions, connectionURI);
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
        if (cacheEntry == null) {
            ConnectionCache connectionCache = this;
            synchronized (connectionCache) {
                cacheEntry = (CacheEntry)this.cache.get(key);
                if (cacheEntry == null) {
                    IoFuture futureConnection = clientEndpoint.connect(connectionURI, connectOptions, callbackHandler);
                    cacheEntry = new CacheEntry(new ConnectionWrapper(key, (Connection)IoFutureHelper.get(futureConnection, connectionTimeout, TimeUnit.MILLISECONDS)));
                    this.cache.put(key, cacheEntry);
                }
            }
        }
        cacheEntry.referenceCount.incrementAndGet();
        return cacheEntry.connection;
    }

    public void release(Object connectionHash) {
        this.release(connectionHash, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object connectionHash, boolean async) {
        block7: {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(connectionHash);
            if (cacheEntry.referenceCount.decrementAndGet() == 0) {
                try {
                    if (async) {
                        cacheEntry.connection.closeAsync();
                        break block7;
                    }
                    try {
                        cacheEntry.connection.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to close connection", e);
                    }
                }
                finally {
                    this.cache.remove(connectionHash);
                }
            }
        }
    }

    public synchronized void shutdown() {
        for (Map.Entry entry : this.cache.entrySet()) {
            ConnectionCache.safeClose((Closeable)((CacheEntry)entry.getValue()).connection);
        }
    }

    private static void safeClose(Closeable closable) {
        try {
            closable.close();
        }
        catch (Throwable t) {
            logger.debug((Object)"Failed to close connection ", t);
        }
    }

    private static final class CacheKey {
        final URI destination;
        final OptionMap connectOptions;
        final Class<?> callbackHandlerClass;

        private CacheKey(Class<?> callbackHandlerClass, OptionMap connectOptions, URI destination) {
            this.callbackHandlerClass = callbackHandlerClass;
            this.connectOptions = connectOptions;
            this.destination = destination;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.callbackHandlerClass != null ? !this.callbackHandlerClass.equals(cacheKey.callbackHandlerClass) : cacheKey.callbackHandlerClass != null) {
                return false;
            }
            if (this.connectOptions != null ? !this.connectOptions.equals(cacheKey.connectOptions) : cacheKey.connectOptions != null) {
                return false;
            }
            return !(this.destination != null ? !this.destination.equals(cacheKey.destination) : cacheKey.destination != null);
        }

        public int hashCode() {
            int result = this.destination != null ? this.destination.hashCode() : 0;
            result = 31 * result + (this.connectOptions != null ? this.connectOptions.hashCode() : 0);
            result = 31 * result + (this.callbackHandlerClass != null ? this.callbackHandlerClass.hashCode() : 0);
            return result;
        }
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private volatile Connection connection;

        private CacheEntry(Connection connection) {
            this.connection = connection;
        }
    }

    private class ConnectionWrapper
    implements Connection {
        private final CacheKey connectionHash;
        private final Connection delegate;

        private ConnectionWrapper(CacheKey connectionHash, Connection delegate) {
            this.delegate = delegate;
            this.connectionHash = connectionHash;
        }

        public Collection<Principal> getPrincipals() {
            return this.delegate.getPrincipals();
        }

        public IoFuture<Channel> openChannel(String s, OptionMap optionMap) {
            return this.delegate.openChannel(s, optionMap);
        }

        public String getRemoteEndpointName() {
            return this.delegate.getRemoteEndpointName();
        }

        public Endpoint getEndpoint() {
            return this.delegate.getEndpoint();
        }

        public void close() throws IOException {
            ConnectionCache.this.release(this.connectionHash);
        }

        public void awaitClosed() throws InterruptedException {
            this.delegate.awaitClosed();
        }

        public void awaitClosedUninterruptibly() {
            this.delegate.awaitClosedUninterruptibly();
        }

        public void closeAsync() {
            ConnectionCache.this.release(this.connectionHash, true);
        }

        public HandleableCloseable.Key addCloseHandler(CloseHandler<? super Connection> closeHandler) {
            return this.delegate.addCloseHandler(closeHandler);
        }

        public Attachments getAttachments() {
            return this.delegate.getAttachments();
        }
    }
}

