/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.JVMDescriptions;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.dmr.ModelNode;

public final class JVMAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final JVMAddHandler INSTANCE = new JVMAddHandler(false);
    public static final JVMAddHandler SERVER_INSTANCE = new JVMAddHandler(true);
    private final boolean server;

    private JVMAddHandler(boolean server) {
        this.server = server;
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) {
        ModelNode jvmType = model.get("type");
        if (operation.hasDefined("type")) {
            jvmType.set(operation.get("type"));
        }
        for (String attr : JVMHandlers.ATTRIBUTES) {
            if (operation.has(attr)) {
                model.get(attr).set(operation.get(attr));
                continue;
            }
            model.get(attr);
        }
        if (this.server) {
            for (String attr : JVMHandlers.SERVER_ATTRIBUTES) {
                if (operation.has(attr)) {
                    model.get(attr).set(operation.get(attr));
                    continue;
                }
                model.get(attr);
            }
        }
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        if (this.server) {
            return JVMDescriptions.getServerJVMAddDescription(locale);
        }
        return JVMDescriptions.getJVMAddDescription(locale);
    }
}

