/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.wsaddressing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ResourceBundle;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxws.wsaddressing.NativeEndpointReference;

public class EndpointReferenceUtil {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointReferenceUtil.class);

    public static <T extends EndpointReference> T transform(Class<T> clazz, EndpointReference epr) {
        assert (epr != null);
        if (clazz.isAssignableFrom(W3CEndpointReference.class)) {
            if (epr instanceof W3CEndpointReference) {
                return (T)epr;
            }
            if (epr instanceof NativeEndpointReference) {
                return (T)W3CEndpointReference.readFrom((Source)EndpointReferenceUtil.getSourceFromEndpointReference(epr));
            }
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_EPR", (Object[])new Object[]{epr}));
        }
        if (clazz.isAssignableFrom(NativeEndpointReference.class)) {
            return (T)NativeEndpointReference.readFrom(EndpointReferenceUtil.getSourceFromEndpointReference(epr));
        }
        throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EPR_OF_TYPE_NOT_SUPPORTED", (Object[])new Object[]{clazz}));
    }

    public static Source getSourceFromEndpointReference(EndpointReference epr) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        epr.writeTo((Result)result);
        return new StreamSource(new ByteArrayInputStream(outputStream.toByteArray()));
    }
}

