/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public final class Index {
    private static final List<AnnotationInstance> EMPTY_ANNOTATION_LIST = Collections.emptyList();
    private static final List<ClassInfo> EMPTY_CLASSINFO_LIST = Collections.emptyList();
    final Map<DotName, List<AnnotationInstance>> annotations;
    final Map<DotName, List<ClassInfo>> subclasses;
    final Map<DotName, List<ClassInfo>> implementors;
    final Map<DotName, ClassInfo> classes;

    Index(Map<DotName, List<AnnotationInstance>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, List<ClassInfo>> implementors, Map<DotName, ClassInfo> classes) {
        this.annotations = Collections.unmodifiableMap(annotations);
        this.classes = Collections.unmodifiableMap(classes);
        this.subclasses = Collections.unmodifiableMap(subclasses);
        this.implementors = Collections.unmodifiableMap(implementors);
    }

    public static Index create(Map<DotName, List<AnnotationInstance>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, List<ClassInfo>> implementors, Map<DotName, ClassInfo> classes) {
        return new Index(annotations, subclasses, implementors, classes);
    }

    public List<AnnotationInstance> getAnnotations(DotName annotationName) {
        List<AnnotationInstance> list = this.annotations.get(annotationName);
        return list == null ? EMPTY_ANNOTATION_LIST : Collections.unmodifiableList(list);
    }

    public List<ClassInfo> getKnownDirectSubclasses(DotName className) {
        List<ClassInfo> list = this.subclasses.get(className);
        return list == null ? EMPTY_CLASSINFO_LIST : Collections.unmodifiableList(list);
    }

    public List<ClassInfo> getKnownDirectImplementors(DotName className) {
        List<ClassInfo> list = this.implementors.get(className);
        return list == null ? EMPTY_CLASSINFO_LIST : Collections.unmodifiableList(list);
    }

    public ClassInfo getClassByName(DotName className) {
        return this.classes.get(className);
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.classes.values();
    }

    public void printAnnotations() {
        System.out.println("Annotations:");
        for (Map.Entry<DotName, List<AnnotationInstance>> e : this.annotations.entrySet()) {
            System.out.println(e.getKey() + ":");
            for (AnnotationInstance instance : e.getValue()) {
                AnnotationTarget target = instance.target();
                if (target instanceof ClassInfo) {
                    System.out.println("    Class: " + target);
                } else if (target instanceof FieldInfo) {
                    System.out.println("    Field: " + target);
                } else if (target instanceof MethodInfo) {
                    System.out.println("    Method: " + target);
                } else if (target instanceof MethodParameterInfo) {
                    System.out.println("    Parameter: " + target);
                }
                List<AnnotationValue> values = instance.values();
                if (values.size() < 1) continue;
                StringBuilder builder = new StringBuilder("        (");
                for (int i = 0; i < values.size(); ++i) {
                    builder.append(values.get(i));
                    if (i >= values.size() - 1) continue;
                    builder.append(", ");
                }
                builder.append(')');
                System.out.println(builder.toString());
            }
        }
    }

    public void printSubclasses() {
        System.out.println("Subclasses:");
        for (Map.Entry<DotName, List<ClassInfo>> entry : this.subclasses.entrySet()) {
            System.out.println(entry.getKey() + ":");
            for (ClassInfo clazz : entry.getValue()) {
                System.out.println("    " + clazz.name());
            }
        }
    }
}

