/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserController;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.wsse.WSSecurityParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustOnBehalfOfParser;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.ComputedKeyType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.LifetimeType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RequestedProofTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.RequestedSecurityTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedTokenCancelledType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.utility.AttributedDateTime;
import org.w3c.dom.Element;

public class WSTRequestSecurityTokenResponseParser
implements ParserNamespaceSupport {
    protected Logger log = Logger.getLogger(WSTRequestSecurityTokenResponseParser.class);
    protected boolean trace = this.log.isTraceEnabled();
    public static final String X509CERTIFICATE = "X509Certificate";
    public static final String KEYVALUE = "KeyValue";
    public static final String JDK_TRANSFORMER_PROPERTY = "picketlink.jdk.transformer";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        RequestSecurityTokenResponse responseToken = new RequestSecurityTokenResponse();
        QName contextQName = new QName("", "Context");
        Attribute contextAttribute = startElement.getAttributeByName(contextQName);
        String contextValue = StaxParserUtil.getAttributeValue(contextAttribute);
        responseToken.setContext(contextValue);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent == null) break;
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals("RequestSecurityTokenResponse")) break;
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + endElementTag);
            }
            try {
                ParserNamespaceSupport parser;
                EndElement endElement;
                Attribute typeAttribute;
                BinarySecretType binarySecret;
                String value;
                StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
                if (subEvent == null) break;
                String tag = StaxParserUtil.getStartElementName(subEvent);
                if (tag.equals("RequestType")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:request type");
                    }
                    value = StaxParserUtil.getElementText(xmlEventReader);
                    responseToken.setRequestType(new URI(value));
                    continue;
                }
                if (tag.equals("Lifetime")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    StaxParserUtil.validate(subEvent, "Lifetime");
                    LifetimeType lifeTime = new LifetimeType();
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    String subTag = StaxParserUtil.getStartElementName(subEvent);
                    if (subTag.equals("Created")) {
                        AttributedDateTime created = new AttributedDateTime();
                        created.setValue(StaxParserUtil.getElementText(xmlEventReader));
                        lifeTime.setCreated(created);
                    }
                    if (!(subTag = StaxParserUtil.getStartElementName(subEvent = StaxParserUtil.getNextStartElement(xmlEventReader))).equals("Expires")) {
                        throw new RuntimeException("PL00062: Parser : Unknown tag:" + subTag);
                    }
                    AttributedDateTime expires = new AttributedDateTime();
                    expires.setValue(StaxParserUtil.getElementText(xmlEventReader));
                    lifeTime.setExpires(expires);
                    responseToken.setLifetime(new Lifetime(lifeTime));
                    EndElement lifeTimeElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(lifeTimeElement, "Lifetime");
                    continue;
                }
                if (tag.equals("TokenType")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:token type");
                    }
                    value = StaxParserUtil.getElementText(xmlEventReader);
                    responseToken.setTokenType(new URI(value));
                    continue;
                }
                if (tag.equals("OnBehalfOf")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    WSTrustOnBehalfOfParser wstOnBehalfOfParser = new WSTrustOnBehalfOfParser();
                    OnBehalfOfType onBehalfOf = (OnBehalfOfType)wstOnBehalfOfParser.parse(xmlEventReader);
                    responseToken.setOnBehalfOf(onBehalfOf);
                    EndElement onBehalfOfEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(onBehalfOfEndElement, "OnBehalfOf");
                    continue;
                }
                if (tag.equals("KeyType")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:key type");
                    }
                    String keyType = StaxParserUtil.getElementText(xmlEventReader);
                    try {
                        URI keyTypeURI = new URI(keyType);
                        responseToken.setKeyType(keyTypeURI);
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new ParsingException(e);
                    }
                }
                if (tag.equals("KeySize")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:key size");
                    }
                    String keySize = StaxParserUtil.getElementText(xmlEventReader);
                    try {
                        responseToken.setKeySize(Long.parseLong(keySize));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ParsingException(e);
                    }
                }
                if (tag.equals("Entropy")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    EntropyType entropy = new EntropyType();
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (StaxParserUtil.matches(subEvent, "BinarySecret")) {
                        binarySecret = new BinarySecretType();
                        typeAttribute = subEvent.getAttributeByName(new QName("", "Type"));
                        binarySecret.setType(StaxParserUtil.getAttributeValue(typeAttribute));
                        if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                            throw new ParsingException("PL00071: Parser: Expected text value:binary secret value");
                        }
                        binarySecret.setValue(StaxParserUtil.getElementText(xmlEventReader).getBytes());
                        entropy.addAny(binarySecret);
                    }
                    responseToken.setEntropy(entropy);
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement, "Entropy");
                    continue;
                }
                if (tag.equals("UseKey")) {
                    Element domElement;
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    UseKeyType useKeyType = new UseKeyType();
                    StaxParserUtil.validate(subEvent, "UseKey");
                    subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
                    if (StaxParserUtil.matches(subEvent, X509CERTIFICATE)) {
                        domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                        useKeyType.add(domElement);
                        responseToken.setUseKey(useKeyType);
                        continue;
                    }
                    if (StaxParserUtil.matches(subEvent, KEYVALUE)) {
                        domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                        useKeyType.add(domElement);
                        responseToken.setUseKey(useKeyType);
                        continue;
                    }
                    throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + StaxParserUtil.getStartElementName(subEvent));
                }
                if (tag.equals("RequestedTokenCancelled")) {
                    StaxParserUtil.getNextEndElement(xmlEventReader);
                    responseToken.setRequestedTokenCancelled(new RequestedTokenCancelledType());
                    continue;
                }
                if (tag.equals("RequestedProofToken")) {
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    RequestedProofTokenType requestedProofToken = new RequestedProofTokenType();
                    subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                    if (StaxParserUtil.matches(subEvent, "BinarySecret")) {
                        binarySecret = new BinarySecretType();
                        typeAttribute = subEvent.getAttributeByName(new QName("", "Type"));
                        binarySecret.setType(StaxParserUtil.getAttributeValue(typeAttribute));
                        if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                            throw new ParsingException("PL00071: Parser: Expected text value:binary secret value");
                        }
                        binarySecret.setValue(StaxParserUtil.getElementText(xmlEventReader).getBytes());
                        requestedProofToken.add(binarySecret);
                    } else if (StaxParserUtil.matches(subEvent, "ComputedKey")) {
                        ComputedKeyType computedKey = new ComputedKeyType();
                        if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                            throw new ParsingException("PL00071: Parser: Expected text value:computed key algorithm");
                        }
                        computedKey.setAlgorithm(StaxParserUtil.getElementText(xmlEventReader));
                        requestedProofToken.add(computedKey);
                    }
                    responseToken.setRequestedProofToken(requestedProofToken);
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement, "RequestedProofToken");
                    continue;
                }
                if (tag.equals("RequestedSecurityToken")) {
                    responseToken.setRequestedSecurityToken(this.parseRequestedSecurityTokenType(xmlEventReader));
                    continue;
                }
                if (tag.equals("RequestedAttachedReference")) {
                    responseToken.setRequestedAttachedReference(this.parseRequestedReference(xmlEventReader));
                    continue;
                }
                if (tag.equals("Status")) {
                    responseToken.setStatus(this.parseStatusType(xmlEventReader));
                    continue;
                }
                QName qname = subEvent.getName();
                if (this.trace) {
                    this.log.trace((Object)("Looking for Parser for :" + qname));
                }
                if ((parser = ParserController.get(qname)) == null) {
                    throw new RuntimeException("PL00062: Parser : Unknown tag:" + qname);
                }
                Object parsedObject = parser.parse(xmlEventReader);
                if (!(parsedObject instanceof AppliesTo)) continue;
                responseToken.setAppliesTo((AppliesTo)parsedObject);
            }
            catch (URISyntaxException e) {
                throw new ParsingException(e);
            }
        }
        return responseToken;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(nsURI) && "RequestSecurityToken".equals(localPart);
    }

    private StatusType parseStatusType(XMLEventReader xmlEventReader) throws ParsingException {
        StatusType status = new StatusType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "Status");
        XMLEvent xmlEvent = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)xmlEvent);
                if (endElementTag.equals("Status")) {
                    xmlEvent = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + endElementTag);
            }
            startElement = (StartElement)xmlEvent;
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("Code")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, "Code");
                if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                    throw new ParsingException("PL00071: Parser: Expected text value:Validation code");
                }
                status.setCode(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (!tag.equals("Reason")) continue;
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            StaxParserUtil.validate(startElement, "Reason");
            if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                throw new ParsingException("PL00071: Parser: Expected text value:Validation reason");
            }
            status.setReason(StaxParserUtil.getElementText(xmlEventReader));
        }
        return status;
    }

    private RequestedSecurityTokenType parseRequestedSecurityTokenType(XMLEventReader xmlEventReader) throws ParsingException {
        RequestedSecurityTokenType requestedSecurityTokenType = new RequestedSecurityTokenType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "RequestedSecurityToken");
        XMLEvent xmlEvent = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)xmlEvent);
                if (endElementTag.equals("RequestedSecurityToken")) {
                    xmlEvent = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + endElementTag);
            }
            Element tokenElement = StaxParserUtil.getDOMElement(xmlEventReader);
            requestedSecurityTokenType.add(tokenElement);
        }
        return requestedSecurityTokenType;
    }

    private RequestedReferenceType parseRequestedReference(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "RequestedAttachedReference");
        RequestedReferenceType ref = new RequestedReferenceType();
        WSSecurityParser wsseParser = new WSSecurityParser();
        SecurityTokenReferenceType secref = (SecurityTokenReferenceType)wsseParser.parse(xmlEventReader);
        ref.setSecurityTokenReference(secref);
        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
        StaxParserUtil.validate(endElement, "RequestedAttachedReference");
        return ref;
    }
}

