/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.wsaddressing;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.w3c.dom.Element;

@XmlRootElement(name="EndpointReference", namespace="http://www.w3.org/2005/08/addressing")
@XmlType(name="EndpointReferenceType", namespace="http://www.w3.org/2005/08/addressing")
public final class NativeEndpointReference
extends EndpointReference {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NativeEndpointReference.class);
    protected static final String WSA_NS = "http://www.w3.org/2005/08/addressing";
    private static final String WSAM_NS = "http://www.w3.org/2007/05/addressing/metadata";
    private static final String WSDLI_NS = "http://www.w3.org/ns/wsdl-instance";
    private static final QName SERVICE_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "ServiceName", "wsam");
    private static final QName INTERFACE_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "InterfaceName", "wsam");
    private static final QName WSDL_LOCATION_QNAME = new QName("http://www.w3.org/ns/wsdl-instance", "wsdlLocation", "wsdli");
    private static final String ENDPOINT_ATTRIBUTE = "EndpointName";
    private static final JAXBContext jc = NativeEndpointReference.getJaxbContext();
    @XmlElement(name="Address", namespace="http://www.w3.org/2005/08/addressing")
    private Address address;
    @XmlElement(name="ReferenceParameters", namespace="http://www.w3.org/2005/08/addressing")
    private Elements referenceParameters;
    @XmlElement(name="Metadata", namespace="http://www.w3.org/2005/08/addressing")
    private Elements metadata;
    @XmlAnyAttribute
    private Map<QName, String> attributes;
    @XmlAnyElement
    private List<Element> elements;
    private QName serviceName;
    private Element serviceNameElement;
    private QName endpointName;
    private QName interfaceName;
    private String wsdlLocation;

    public NativeEndpointReference() {
    }

    public NativeEndpointReference(Source source) {
        try {
            NativeEndpointReference epr = (NativeEndpointReference)((Object)jc.createUnmarshaller().unmarshal(source, NativeEndpointReference.class).getValue());
            this.address = epr.address;
            if (epr.referenceParameters != null && !epr.referenceParameters.isEmpty()) {
                this.referenceParameters = epr.referenceParameters;
            }
            if (epr.metadata != null && !epr.metadata.isEmpty()) {
                this.metadata = epr.metadata;
            }
            this.attributes = epr.attributes;
            this.elements = epr.elements;
            if (epr.metadata != null) {
                List<Element> metadataElements;
                String wsdlLocation;
                Map<QName, String> metadataAttributes = epr.metadata.getAttributes();
                if (metadataAttributes != null && (wsdlLocation = metadataAttributes.get(WSDL_LOCATION_QNAME)) != null) {
                    int spaceIndex = wsdlLocation.indexOf(" ");
                    if (spaceIndex == -1) {
                        throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SPECIFY_NS_WSLOCATION", (Object[])new Object[0]));
                    }
                    this.setWsdlLocation(wsdlLocation.substring(spaceIndex).trim());
                }
                if ((metadataElements = epr.metadata.getElements()) != null) {
                    for (Element e : epr.metadata.getElements()) {
                        if (!WSAM_NS.equals(e.getNamespaceURI())) continue;
                        if (e.getLocalName().equals(SERVICE_QNAME.getLocalPart())) {
                            this.serviceName = this.getQName(e, e.getTextContent());
                            String endpointName = e.getAttribute(ENDPOINT_ATTRIBUTE);
                            if (endpointName != null) {
                                this.endpointName = new QName(this.serviceName.getNamespaceURI(), endpointName, this.serviceName.getPrefix());
                            }
                        }
                        if (!e.getLocalName().equals(INTERFACE_QNAME.getLocalPart())) continue;
                        this.interfaceName = this.getQName(e, e.getTextContent());
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_UNMARSHALLING_NATIVEEPR", (Object[])new Object[0]), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOURCE_DID_NOT_CONTAIN_NATIVEEPR", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @XmlTransient
    public String getAddress() {
        return this.address != null ? this.address.getUri() : null;
    }

    public void setAddress(String address) {
        if (address == null) {
            return;
        }
        this.address = new Address(address);
    }

    @XmlTransient
    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        if (serviceName == null) {
            return;
        }
        this.serviceName = serviceName;
        this.serviceNameElement = DOMUtils.createElement((QName)SERVICE_QNAME);
        String attrName = this.getNamespaceAttributeName(serviceName.getPrefix());
        this.serviceNameElement.setAttribute(attrName, serviceName.getNamespaceURI());
        this.serviceNameElement.setTextContent(this.toString(serviceName));
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.addElement(this.serviceNameElement);
    }

    @XmlTransient
    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(QName endpointName) {
        if (endpointName == null) {
            return;
        }
        this.endpointName = endpointName;
    }

    @XmlTransient
    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        if (interfaceName == null) {
            return;
        }
        this.interfaceName = interfaceName;
        Element interfaceNameElement = DOMUtils.createElement((QName)INTERFACE_QNAME);
        String attrName = this.getNamespaceAttributeName(interfaceName.getPrefix());
        interfaceNameElement.setAttribute(attrName, interfaceName.getNamespaceURI());
        interfaceNameElement.setTextContent(this.toString(interfaceName));
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.addElement(interfaceNameElement);
    }

    @XmlTransient
    public List<Element> getMetadata() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getElements();
    }

    public void setMetadata(List<Element> metadata) {
        if (metadata == null || metadata.size() == 0) {
            return;
        }
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.setElements(metadata);
    }

    @XmlTransient
    public URL getWsdlLocation() {
        if (this.wsdlLocation != null) {
            return this.toURL(this.wsdlLocation);
        }
        String address = this.getAddress();
        if (address != null) {
            return this.toURL(address + "?wsdl");
        }
        return null;
    }

    public void setWsdlLocation(String wsdlLocation) {
        if (wsdlLocation == null) {
            return;
        }
        this.wsdlLocation = wsdlLocation;
    }

    @XmlTransient
    public List<Element> getReferenceParameters() {
        if (this.referenceParameters == null) {
            return null;
        }
        return this.referenceParameters.getElements();
    }

    public void setReferenceParameters(List<Element> metadata) {
        if (metadata == null || metadata.size() == 0) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new Elements();
        }
        this.referenceParameters.setElements(metadata);
    }

    public static EndpointReference readFrom(Source eprInfoset) {
        if (eprInfoset == null) {
            throw new NullPointerException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PROVIDED_EPRINFOSET_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        try {
            return new NativeEndpointReference(eprInfoset);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public void writeTo(Result result) {
        if (this.endpointName != null && this.serviceNameElement != null) {
            this.serviceNameElement.setAttribute(ENDPOINT_ATTRIBUTE, this.endpointName.getLocalPart());
            if (this.wsdlLocation != null) {
                if (this.metadata == null) {
                    this.metadata = new Elements();
                }
                String wsdlNamespace = null;
                if (this.endpointName != null) {
                    wsdlNamespace = this.endpointName.getNamespaceURI();
                } else if (this.serviceName != null) {
                    wsdlNamespace = this.serviceName.getNamespaceURI();
                }
                if (wsdlNamespace == null && this.wsdlLocation != null) {
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVICENAME_OR_ENDPOINTNAME_HAVE_TO_BE_SPECIFIED", (Object[])new Object[0]));
                }
                this.metadata.addAttribute(WSDL_LOCATION_QNAME, wsdlNamespace + " " + this.wsdlLocation);
            }
        }
        try {
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)this, result);
        }
        catch (JAXBException e) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_MARSHALLING_NATIVEEPR", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private URL toURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static JAXBContext getJaxbContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{NativeEndpointReference.class});
        }
        catch (JAXBException ex) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_JAXB_CONTEXT", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    private String toString(QName qname) {
        StringBuilder sb = new StringBuilder();
        if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
            sb.append(qname.getPrefix());
            sb.append(':');
        }
        sb.append(qname.getLocalPart());
        return sb.toString();
    }

    private QName getQName(Element e, String nodeValue) {
        if (nodeValue == null) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MISSING_TEXT_CONTENT", (Object[])new Object[]{e.getNodeName()}));
        }
        int separatorIndex = nodeValue.indexOf(58);
        if (separatorIndex == -1) {
            String namespace = e.getAttribute("xmlns");
            return new QName(namespace, nodeValue);
        }
        String prefix = nodeValue.substring(0, separatorIndex);
        String localPart = nodeValue.substring(separatorIndex + 1);
        String namespace = e.lookupNamespaceURI(prefix);
        return new QName(namespace, localPart, prefix);
    }

    private String getNamespaceAttributeName(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return "xmlns";
        }
        return "xmlns:" + prefix;
    }

    private static class Elements {
        @XmlAnyElement
        List<Element> elements;
        @XmlAnyAttribute
        Map<QName, String> attributes;

        protected Elements() {
        }

        public Elements(List<Element> elements) {
            this.elements = elements;
        }

        @XmlTransient
        public List<Element> getElements() {
            return this.elements;
        }

        public void setElements(List<Element> elements) {
            if (this.elements == null) {
                this.elements = elements;
            } else {
                this.elements.addAll(elements);
            }
        }

        public void addElement(Element e) {
            if (this.elements == null) {
                this.elements = new LinkedList<Element>();
            }
            this.elements.add(e);
        }

        @XmlTransient
        public Map<QName, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<QName, String> attributes) {
            if (this.attributes == null) {
                this.attributes = attributes;
            } else {
                this.attributes.putAll(attributes);
            }
        }

        public void addAttribute(QName attrName, String attrValue) {
            if (this.attributes == null) {
                this.attributes = new HashMap<QName, String>();
            }
            this.attributes.put(attrName, attrValue);
        }

        @XmlTransient
        public boolean isEmpty() {
            boolean noAttributes = this.attributes == null || this.attributes.size() == 0;
            boolean noElements = this.elements == null || this.elements.size() == 0;
            return noAttributes && noElements;
        }
    }

    private static class Address {
        @XmlValue
        String uri;
        @XmlAnyAttribute
        Map<QName, String> attributes;

        protected Address() {
        }

        public Address(String uri) {
            this.uri = uri;
        }

        @XmlTransient
        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        @XmlTransient
        public Map<QName, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<QName, String> attributes) {
            this.attributes = attributes;
        }
    }
}

