/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.extensions.validation.SchemaExtractor;
import org.jboss.ws.extensions.validation.SchemaValidationHelper;
import org.jboss.ws.feature.SchemaValidationFeature;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class SOAPBodyElementDoc
extends SOAPContentElement
implements SOAPBodyElement {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointMetaData.class);
    private static Logger log = Logger.getLogger(SOAPBodyElementDoc.class);
    private SchemaValidationFeature feature;

    public SOAPBodyElementDoc(Name name) {
        super(name);
    }

    public SOAPBodyElementDoc(QName qname) {
        super(qname);
    }

    public SOAPBodyElementDoc(SOAPElementImpl element) {
        super(element);
    }

    @Override
    protected SOAPContent.State transitionTo(SOAPContent.State nextState) {
        SOAPContent.State prevState = this.soapContent.getState();
        if (nextState != prevState) {
            if (this.isValidationEnabled() && nextState == SOAPContent.State.OBJECT_VALID) {
                log.info((Object)("Validating: " + (Object)((Object)prevState)));
                this.validatePayload(this.soapContent.getPayload());
            }
            prevState = super.transitionTo(nextState);
            if (this.isValidationEnabled() && prevState == SOAPContent.State.OBJECT_VALID) {
                log.info((Object)("Validating: " + (Object)((Object)nextState)));
                this.validatePayload(this.soapContent.getPayload());
            }
        }
        return prevState;
    }

    private void validatePayload(Source source) {
        SchemaExtractor schemaExtractor = new SchemaExtractor();
        try {
            ErrorHandler errorHandler;
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
            this.feature = epMetaData.getFeature(SchemaValidationFeature.class);
            URL xsdURL = this.feature.getSchemaLocation() != null ? new URL(this.feature.getSchemaLocation()) : null;
            InputStream[] xsdStreams = null;
            if (xsdURL == null) {
                URL wsdlURL = epMetaData.getServiceMetaData().getWsdlFileOrLocation();
                if (wsdlURL == null) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"VALIDATION_ERROR", (Object[])new Object[0]));
                } else {
                    xsdStreams = schemaExtractor.getSchemas(wsdlURL);
                }
            }
            if (xsdURL != null) {
                errorHandler = this.feature.getErrorHandler();
                Element xmlDOM = DOMUtils.sourceToElement((Source)source);
                new SchemaValidationHelper(xsdURL).setErrorHandler(errorHandler).validateDocument(xmlDOM);
            } else {
                errorHandler = this.feature.getErrorHandler();
                Element xmlDOM = DOMUtils.sourceToElement((Source)source);
                new SchemaValidationHelper(xsdStreams).setErrorHandler(errorHandler).validateDocument(xmlDOM);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            WSException.rethrow(ex);
        }
    }

    private boolean isValidationEnabled() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            this.feature = msgContext.getEndpointMetaData().getFeature(SchemaValidationFeature.class);
        }
        return this.feature != null ? this.feature.isEnabled() : false;
    }
}

