/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.modcluster.Attribute;
import org.jboss.as.modcluster.Element;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ModClusterSubsystemXMLReader_1_0
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "modcluster");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MOD_CLUSTER_CONFIG: {
                    ModelNode config = ModClusterSubsystemXMLReader_1_0.parseModClusterConfig(reader);
                    subsystem.get("mod-cluster-config").set(config);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseModClusterConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode config = new ModelNode();
        ModClusterSubsystemXMLReader_1_0.parsePropConf(reader, config);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SIMPLE_LOAD_PROVIDER: {
                    ModelNode load = ModClusterSubsystemXMLReader_1_0.parseSimpleLoadProvider(reader);
                    config.get("simple-load-provider").set(load);
                    continue block5;
                }
                case DYNAMIC_LOAD_PROVIDER: {
                    ModelNode dynload = ModClusterSubsystemXMLReader_1_0.parseDynamicLoadProvider(reader);
                    config.get("dynamic-load-provider").set(dynload);
                    continue block5;
                }
                case SSL: {
                    ModelNode ssl = ModClusterSubsystemXMLReader_1_0.parseSSL(reader);
                    config.get("ssl").set(ssl);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return config;
    }

    static void parsePropConf(XMLExtendedStreamReader reader, ModelNode conf) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ADVERTISE_SOCKET: 
                case PROXY_LIST: 
                case PROXY_URL: 
                case ADVERTISE: 
                case ADVERTISE_SECURITY_KEY: 
                case EXCLUDED_CONTEXTS: 
                case AUTO_ENABLE_CONTEXTS: 
                case STOP_CONTEXT_TIMEOUT: 
                case SOCKET_TIMEOUT: 
                case STICKY_SESSION: 
                case STICKY_SESSION_REMOVE: 
                case STICKY_SESSION_FORCE: 
                case WORKER_TIMEOUT: 
                case MAX_ATTEMPTS: 
                case FLUSH_PACKETS: 
                case FLUSH_WAIT: 
                case PING: 
                case SMAX: 
                case TTL: 
                case NODE_TIMEOUT: 
                case BALANCER: 
                case DOMAIN: {
                    ModClusterConfigResourceDefinition.ATTRIBUTES_BY_NAME.get(attribute.getLocalName()).parseAndSetParameter(value, conf, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    static ModelNode parseSSL(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.setEmptyObject();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_ALIAS: 
                case PASSWORD: 
                case CERTIFICATE_KEY_FILE: 
                case CIPHER_SUITE: 
                case PROTOCOL: 
                case CA_CERTIFICATE_FILE: 
                case CA_REVOCATION_URL: {
                    ModClusterSSLResourceDefinition.ATTRIBUTES_BY_NAME.get(attribute.getLocalName()).parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return ssl;
    }

    static ModelNode parseSimpleLoadProvider(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTOR: {
                    load.get("factor").set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return load;
    }

    static ModelNode parseDynamicLoadProvider(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HISTORY: {
                    load.get("history").set(value);
                    continue block8;
                }
                case DECAY: {
                    load.get("decay").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOAD_METRIC: {
                    ModelNode loadmetric = ModClusterSubsystemXMLReader_1_0.parseLoadMetric(reader);
                    load.get("load-metric").add(loadmetric);
                    continue block9;
                }
                case CUSTOM_LOAD_METRIC: {
                    ModelNode customloadmetric = ModClusterSubsystemXMLReader_1_0.parseCustomLoadMetric(reader);
                    load.get("custom-load-metric").add(customloadmetric);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static ModelNode parseLoadMetric(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    load.get("type").set(value);
                    continue block8;
                }
                case CAPACITY: {
                    load.get("capacity").set(value);
                    continue block8;
                }
                case WEIGHT: {
                    load.get("weight").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ModClusterSubsystemXMLReader_1_0.parseProperty(reader);
                    load.get("property").add(property.getName(), property.getValue());
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static ModelNode parseCustomLoadMetric(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CAPACITY: {
                    load.get("capacity").set(value);
                    continue block8;
                }
                case WEIGHT: {
                    load.get("weight").set(value);
                    continue block8;
                }
                case CLASS: {
                    load.get("class").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ModClusterSubsystemXMLReader_1_0.parseProperty(reader);
                    load.get("property").add(property.getName(), property.getValue());
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static Property parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new Property(name, new ModelNode().set(value == null ? "" : value));
    }
}

