/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagementStrategyImpl
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private final ViewDeclarationLanguageFactory vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext context) {
        if (context == null) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        Util.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        final HashMap<String, Object> stateMap = new HashMap<String, Object>();
        final StateContext stateContext = StateContext.getStateContext(context);
        context.getAttributes().put(SKIP_ITERATION_HINT, true);
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
        final FacesContext finalContext = context;
        try {
            viewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    VisitResult result = VisitResult.ACCEPT;
                    if (!target.isTransient()) {
                        Object stateObj;
                        if (stateContext.componentAddedDynamically(target)) {
                            target.getAttributes().put("com.sun.faces.DynamicComponent", new Integer(target.getParent().getChildren().indexOf(target)));
                            stateObj = new StateHolderSaver(finalContext, target);
                        } else {
                            stateObj = target.saveState(context.getFacesContext());
                        }
                        if (null != stateObj) {
                            stateMap.put(target.getClientId(context.getFacesContext()), stateObj);
                        }
                    } else {
                        return result;
                    }
                    return result;
                }
            });
        }
        finally {
            context.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        this.saveDynamicActions(context, stateContext, stateMap);
        return new Object[]{null, stateMap};
    }

    private void saveDynamicActions(FacesContext context, StateContext stateContext, Map<String, Object> stateMap) {
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        if (actions != null) {
            ArrayList<Object> savedActions = new ArrayList<Object>(actions.size());
            for (ComponentStruct action : actions) {
                savedActions.add(action.saveState(context));
            }
            stateMap.put("com.sun.faces.DynamicActions", savedActions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        boolean processingEvents = context.isProcessingEvents();
        try {
            ViewDeclarationLanguage vdl = this.vdlFactory.getViewDeclarationLanguage(viewId);
            viewRoot = vdl.getViewMetadata(context, viewId).createMetadataView(context);
            context.setViewRoot(viewRoot);
            context.setProcessingEvents(true);
            vdl.buildView(context, viewRoot);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
        Object[] rawState = (Object[])rsm.getState(context, viewId);
        if (rawState == null) {
            return null;
        }
        final Map state = (Map)rawState[1];
        final StateContext stateContext = StateContext.getStateContext(context);
        if (null != state) {
            try {
                stateContext.setTrackViewModifications(false);
                Application app = context.getApplication();
                context.getAttributes().put(SKIP_ITERATION_HINT, true);
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION, VisitHint.EXECUTE_LIFECYCLE);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
                viewRoot.visitTree(visitContext, new VisitCallback(){

                    public VisitResult visit(VisitContext context, UIComponent target) {
                        VisitResult result = VisitResult.ACCEPT;
                        String cid = target.getClientId(context.getFacesContext());
                        Object stateObj = state.get(cid);
                        if (stateObj != null && !stateContext.componentAddedDynamically(target)) {
                            boolean restoreStateNow = true;
                            if (stateObj instanceof StateHolderSaver) {
                                boolean bl = restoreStateNow = !((StateHolderSaver)stateObj).componentAddedDynamically();
                            }
                            if (restoreStateNow) {
                                try {
                                    target.restoreState(context.getFacesContext(), stateObj);
                                }
                                catch (Exception e) {
                                    String msg = MessageUtils.getExceptionMessageString("com.sun.faces.partial.statesaving.ERROR_RESTORING_STATE_FOR_COMPONENT", cid, e.toString());
                                    throw new FacesException(msg, (Throwable)e);
                                }
                            }
                        }
                        return result;
                    }
                });
                this.restoreDynamicActions(context, stateContext, state);
            }
            finally {
                stateContext.setTrackViewModifications(true);
                context.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        } else {
            viewRoot = null;
        }
        context.setProcessingEvents(processingEvents);
        return viewRoot;
    }

    private void restoreDynamicActions(FacesContext context, StateContext stateContext, Map<String, Object> stateMap) {
        List savedActions = (List)stateMap.get("com.sun.faces.DynamicActions");
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        if (savedActions != null && !savedActions.isEmpty()) {
            for (Object object : savedActions) {
                ComponentStruct action = new ComponentStruct();
                action.restoreState(context, object);
                if ("ADD".equals(action.action)) {
                    this.restoreDynamicAdd(context, stateMap, action);
                }
                if ("REMOVE".equals(action.action)) {
                    this.restoreDynamicRemove(context, action);
                }
                this.pruneAndReAddToDynamicActions(actions, action);
            }
        }
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> dynamicActionList, ComponentStruct struct) {
        int firstIndex = dynamicActionList.indexOf(struct);
        if (firstIndex == -1) {
            dynamicActionList.add(struct);
        } else {
            int lastIndex = dynamicActionList.lastIndexOf(struct);
            if (lastIndex == -1 || lastIndex == firstIndex) {
                dynamicActionList.add(struct);
            } else {
                dynamicActionList.remove(lastIndex);
                dynamicActionList.remove(firstIndex);
                dynamicActionList.add(struct);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext context, Map<String, Object> state, ComponentStruct struct) {
        UIComponent parent = this.findComponent(context, struct.parentClientId);
        if (parent != null) {
            UIComponent child = this.findComponent(context, struct.clientId);
            if (child != null) {
                if (struct.facetName == null) {
                    parent.getChildren().remove(child);
                }
            } else {
                StateHolderSaver saver = (StateHolderSaver)state.get(struct.clientId);
                if (saver != null) {
                    child = (UIComponent)saver.restore(context);
                } else {
                    System.out.println("Unable to find state for component with clientId '" + struct.clientId + "', not restoring it.");
                }
            }
            if (child != null) {
                if (struct.facetName != null) {
                    parent.getFacets().put(struct.facetName, child);
                } else {
                    child.setId(struct.id);
                    parent.getChildren().add(child);
                    child.getClientId();
                }
            }
        } else {
            System.out.println("Unable to find parent component with clientId '" + struct.parentClientId + "', not adding child.");
        }
    }

    private void restoreDynamicRemove(FacesContext context, ComponentStruct struct) {
        UIComponent child = this.findComponent(context, struct.clientId);
        if (child != null) {
            UIComponent parent = child.getParent();
            parent.getChildren().remove(child);
        } else {
            System.out.println("Unable to find component with clientId '" + struct.clientId + "', no need to remove it.");
        }
    }

    private UIComponent findComponent(FacesContext context, final String clientId) {
        UIComponent result = context.getViewRoot().findComponent(clientId);
        if (result == null) {
            final ArrayList found = new ArrayList();
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context);
            context.getViewRoot().visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent component) {
                    VisitResult result = VisitResult.ACCEPT;
                    if (component.getClientId(visitContext.getFacesContext()).equals(clientId)) {
                        found.add(component);
                        result = VisitResult.COMPLETE;
                    }
                    return result;
                }
            });
            if (!found.isEmpty()) {
                result = (UIComponent)found.get(0);
            }
        }
        return result;
    }
}

