/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.async;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.handlers.HandlerService;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class AsyncHandlerService
implements HandlerService {
    private final List<InjectedValue<Handler>> subhandlers = new ArrayList<InjectedValue<Handler>>();
    private AsyncHandler.OverflowAction overflowAction;
    private int queueLength;
    private AsyncHandler value;
    private Level level;
    private Filter filter;
    private FormatterSpec formatterSpec;
    private String encoding;
    private boolean autoflush;

    public synchronized void start(StartContext context) throws StartException {
        AsyncHandler handler;
        this.value = handler = new AsyncHandler(this.queueLength);
        this.formatterSpec.apply((Handler)handler);
        handler.setOverflowAction(this.overflowAction);
        handler.setAutoFlush(this.autoflush);
        if (this.filter != null) {
            handler.setFilter(this.filter);
        }
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        Handler[] handlers = new Handler[this.subhandlers.size()];
        int subhandlersSize = this.subhandlers.size();
        for (int i = 0; i < subhandlersSize; ++i) {
            handlers[i] = (Handler)this.subhandlers.get(i).getValue();
        }
        handler.setHandlers(handlers);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
    }

    public synchronized void stop(StopContext context) {
        AsyncHandler handler = this.value;
        handler.close();
        handler.setLevel(Level.OFF);
        handler.clearHandlers();
        this.value = null;
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized void setOverflowAction(AsyncHandler.OverflowAction overflowAction) {
        this.overflowAction = overflowAction;
        AsyncHandler handler = this.value;
        if (handler != null) {
            handler.setOverflowAction(overflowAction);
        }
    }

    public synchronized void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    @Override
    public synchronized void setLevel(Level level) {
        this.level = level;
        AsyncHandler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    @Override
    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
        AsyncHandler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
    }

    @Override
    public synchronized void setFormatterSpec(FormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        AsyncHandler handler = this.value;
        if (handler != null) {
            formatterSpec.apply((Handler)handler);
        }
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
        AsyncHandler handler = this.value;
        if (handler != null) {
            handler.setFilter(filter);
        }
    }

    public synchronized void addHandlers(List<InjectedValue<Handler>> list) {
        this.subhandlers.addAll(list);
        AsyncHandler handler = this.value;
        if (handler != null) {
            for (InjectedValue<Handler> injectedHandler : list) {
                handler.addHandler((Handler)injectedHandler.getValue());
            }
        }
    }

    public synchronized void addHandler(InjectedValue<Handler> injectedHandler) {
        this.subhandlers.add(injectedHandler);
        AsyncHandler handler = this.value;
        if (handler != null) {
            handler.addHandler((Handler)injectedHandler.getValue());
        }
    }

    public synchronized void removeHandler(Handler subHandler) {
        InjectedValue<Handler> valueToRemove = null;
        for (InjectedValue<Handler> injectedHandler : this.subhandlers) {
            if (!((Handler)injectedHandler.getValue()).equals(subHandler)) continue;
            valueToRemove = injectedHandler;
        }
        if (valueToRemove != null) {
            this.subhandlers.remove(valueToRemove);
            AsyncHandler handler = this.value;
            if (handler != null) {
                handler.removeHandler((Handler)valueToRemove.getValue());
            }
        }
    }
}

