/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.PropertiesBootstrapProvider;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class OSGiBootstrapBean {
    private static Logger log;

    public void run() {
        this.initBootstrap();
        OSGiBootstrapProvider bootProvider = OSGiBootstrapBean.getBootstrapProvider();
        Framework framework = bootProvider.getFramework();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new ShutdownThread(framework));
        StartupThread thread = new StartupThread(framework);
        thread.start();
    }

    private void initBootstrap() {
        log = Logger.getLogger(OSGiBootstrapBean.class);
        Properties defaults = new Properties();
        log.debug((Object)"JBoss OSGi System Properties");
        Enumeration<?> defaultNames = defaults.propertyNames();
        while (defaultNames.hasMoreElements()) {
            String propName = (String)defaultNames.nextElement();
            String sysValue = System.getProperty(propName);
            if (sysValue != null) continue;
            String propValue = defaults.getProperty(propName);
            System.setProperty(propName, propValue);
            log.debug((Object)("   " + propName + "=" + propValue));
        }
    }

    public static OSGiBootstrapProvider getBootstrapProvider() {
        if (log == null) {
            log = Logger.getLogger(OSGiBootstrap.class);
        }
        OSGiBootstrapProvider provider = null;
        List<OSGiBootstrapProvider> providers = ServiceLoader.loadServices(OSGiBootstrapProvider.class);
        for (OSGiBootstrapProvider aux : providers) {
            try {
                aux.configure();
                provider = aux;
                break;
            }
            catch (Exception ex) {
                log.debug((Object)("Cannot configure [" + aux.getClass().getName() + "]"), (Throwable)ex);
            }
        }
        if (provider == null) {
            provider = new PropertiesBootstrapProvider();
            log.debug((Object)("Using default: " + PropertiesBootstrapProvider.class.getName()));
        }
        return provider;
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
    }

    class ShutdownThread
    extends Thread {
        private Framework framework;

        public ShutdownThread(Framework framework) {
            this.framework = framework;
        }

        @Override
        public void run() {
            log.info((Object)"Initiating shutdown ...");
            try {
                this.framework.stop();
                this.framework.waitForStop(5000L);
            }
            catch (Exception ex) {
                log.error((Object)"Cannot stop framework", (Throwable)ex);
            }
            log.info((Object)"Shutdown complete");
        }
    }

    class StartupThread
    extends Thread {
        private Framework framework;

        public StartupThread(Framework framework) {
            this.framework = framework;
        }

        @Override
        public void run() {
            long beforeStart = System.currentTimeMillis();
            try {
                this.framework.start();
            }
            catch (BundleException ex) {
                throw new IllegalStateException("Cannot start framework", ex);
            }
            float diff = (float)(System.currentTimeMillis() - beforeStart) / 1000.0f;
            log.info((Object)("JBossOSGi Runtime booted in " + diff + "sec"));
            InputStreamReader br = new InputStreamReader(System.in);
            try {
                int inByte = ((Reader)br).read();
                while (inByte != -1) {
                    inByte = ((Reader)br).read();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

