/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Permission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointContext;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServicePermission;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.spi.http.HttpContext;
import org.jboss.ws.core.jaxws.spi.http.HttpServer;
import org.jboss.ws.core.jaxws.spi.http.NettyHttpServerFactory;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Element;

public class EndpointImpl
extends Endpoint {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointImpl.class);
    private static final Logger log = Logger.getLogger(EndpointImpl.class);
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object implementor;
    private Executor executor;
    private WebServiceFeature[] features;
    private List<Source> metadata;
    private BindingProviderImpl bindingProvider;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private HttpContext serverContext;
    private boolean isPublished;
    private boolean isDestroyed;
    private URI address;
    private Deployment dep;

    public EndpointImpl(String bindingId, Object implementor, WebServiceFeature[] features) {
        if (implementor == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"IMPLEMENTOR_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.implementor = implementor;
        this.bindingProvider = new BindingProviderImpl(bindingId);
        this.features = features;
    }

    public Binding getBinding() {
        return this.bindingProvider.getBinding();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void publish(String addr) {
        log.debug((Object)("publish: " + addr));
        try {
            this.address = new URI(addr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_ADDRESS", (Object[])new Object[]{addr}));
        }
        this.checkPublishEndpointPermission();
        HttpServer httpServer = NettyHttpServerFactory.getHttpServer();
        HttpContext context = httpServer.createContext(this.getContextRoot());
        this.publish(context);
    }

    public void publish(Object context) {
        if (context == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NULL_CONTEXT", (Object[])new Object[0]));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("publishing endpoint " + (Object)((Object)this) + " to " + context));
        }
        if (this.isDestroyed) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_ALREADY_DESTROYED", (Object[])new Object[0]));
        }
        this.checkPublishEndpointPermission();
        if (context instanceof HttpContext) {
            this.serverContext = (HttpContext)context;
            if (this.address == null) {
                this.address = EndpointImpl.getAddressFromConfigAndContext(this.serverContext);
            }
        } else {
            throw new UnsupportedOperationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_HANDLE_CONTEXTS", (Object[])new Object[]{context}));
        }
        HttpServer httpServer = this.serverContext.getHttpServer();
        httpServer.publish(this.serverContext, this);
        this.isPublished = true;
    }

    private static URI getAddressFromConfigAndContext(HttpContext context) {
        try {
            SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
            ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
            ServerConfig serverConfig = spi.getServerConfig();
            String host = serverConfig.getWebServiceHost();
            int port = serverConfig.getWebServicePort();
            String hostAndPort = host + (port > 0 ? ":" + port : "");
            return new URI("http://" + hostAndPort + context.getContextRoot());
        }
        catch (URISyntaxException e) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_GETTING_ENDPOINT_ADDRESS", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public void stop() {
        log.debug((Object)"stop");
        if (this.serverContext == null || !this.isPublished) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_NOT_PUBLISHED", (Object[])new Object[0]));
        }
        try {
            if (this.serverContext != null) {
                HttpServer httpServer = this.serverContext.getHttpServer();
                httpServer.destroy(this.serverContext, this);
            }
        }
        catch (Exception ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_STOP_ENDPOINT", (Object[])new Object[0]), (Throwable)ex);
        }
        this.isPublished = false;
        this.isDestroyed = true;
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    public List<Source> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Source> list) {
        log.info((Object)"Ignore metadata, not implemented");
        this.metadata = list;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        log.info((Object)"Ignore executor, not implemented");
        this.executor = executor;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    private void checkPublishEndpointPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)ENDPOINT_PUBLISH_PERMISSION);
        }
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (this.isDestroyed || !this.isPublished) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_EPR_FOR_ENDPOINT", (Object[])new Object[0]));
        }
        if (this.getBinding() instanceof HTTPBinding) {
            throw new UnsupportedOperationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_EPR_WITH_XML_BINDING", (Object[])new Object[0]));
        }
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(this.address.toString());
        builder.wsdlDocumentLocation(this.address.toString() + "?wsdl");
        if (referenceParameters != null && W3CEndpointReference.class.getName().equals(clazz.getName())) {
            for (Element el : referenceParameters) {
                builder.referenceParameter(el);
            }
        }
        return EndpointReferenceUtil.transform(clazz, (EndpointReference)builder.build());
    }

    public String getPath() {
        String path = this.address.getPath();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String getContextRoot() {
        StringTokenizer st = new StringTokenizer(this.getPath(), "/");
        String contextRoot = "/";
        if (st.hasMoreTokens()) {
            contextRoot = contextRoot + st.nextToken();
        }
        return contextRoot;
    }

    public String getPathWithoutContext() {
        StringTokenizer st = new StringTokenizer(this.getPath(), "/");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            sb.append('/');
            sb.append(st.nextToken());
        }
        sb.append('/');
        return sb.toString();
    }

    public void setDeployment(Deployment dep) {
        if (this.dep == null) {
            this.dep = dep;
        }
    }

    public Deployment getDeployment() {
        return this.dep;
    }

    public void publish(javax.xml.ws.spi.http.HttpContext serverContext) {
        log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"PUBLISH_NOT_IMPLEMENT", (Object[])new Object[0]));
    }

    public void setEndpointContext(EndpointContext endpointContext) {
        log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"SETENDPOINTCONTEXT_NOT_IMPLEMENT", (Object[])new Object[0]));
    }
}

