/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityTokenReference {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SecurityTokenReference.class);
    private String id;
    private Reference reference;
    private Element cachedElement;

    public SecurityTokenReference(Reference reference) {
        this.reference = reference;
    }

    public SecurityTokenReference(Element element) throws WSSecurityException {
        Element child;
        if (!"SecurityTokenReference".equals(element.getLocalName())) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SECURITYTOKENREFERENCE_INVALID_LOCAL_NAME", (Object[])new Object[0]));
        }
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            this.setId(id);
        }
        if ((child = Util.getFirstChildElement(element)) == null) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SECURITYTOKENREFENCE_IS_EMPTY", (Object[])new Object[]{id}));
        }
        this.reference = Reference.getReference(child);
    }

    public Reference getReference() {
        return this.reference;
    }

    public String getId() {
        if (this.id == null) {
            this.id = Util.generateId("reference");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Element getElement() throws WSSecurityException {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element referenceElement = this.reference.getElement();
        Document doc = referenceElement.getOwnerDocument();
        Element element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.getId());
        element.appendChild(referenceElement);
        this.cachedElement = element;
        return this.cachedElement;
    }
}

