/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.ws.common.utils.JBossWSEntityResolver;
import org.jboss.ws.metadata.config.binding.OMFactoryJAXRPC;
import org.jboss.ws.metadata.config.jaxrpc.CommonConfigJAXRPC;
import org.jboss.ws.metadata.config.jaxrpc.ConfigRootJAXRPC;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class JBossWSConfigFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JBossWSConfigFactory.class);
    private final Logger log = Logger.getLogger(JBossWSConfigFactory.class);
    private static String URN_JAXRPC_CONFIG = "urn:jboss:jaxrpc-config:2.0";
    private static String URN_JAXWS_CONFIG = "urn:jboss:jbossws-jaxws-config:4.0";
    private ClassLoader loader;

    private JBossWSConfigFactory(ClassLoader loader) {
        this.loader = new DelegateClassLoader(JBossWSConfigFactory.class.getClassLoader(), loader);
    }

    public static JBossWSConfigFactory newInstance() {
        return new JBossWSConfigFactory(JBossWSConfigFactory.getContextClassLoader());
    }

    public static JBossWSConfigFactory newInstance(ClassLoader loader) {
        return new JBossWSConfigFactory(loader);
    }

    public Object parse(URL configURL) {
        Object wsConfig;
        block14: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("parse: " + configURL));
            }
            InputStream is = null;
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                unmarshaller.setValidation(true);
                unmarshaller.setSchemaValidation(true);
                unmarshaller.setEntityResolver((EntityResolver)new JBossWSEntityResolver(this.loader));
                String nsURI = this.getNamespaceURI(configURL);
                is = configURL.openStream();
                if (URN_JAXRPC_CONFIG.equals(nsURI)) {
                    wsConfig = unmarshaller.unmarshal(is, (ObjectModelFactory)new OMFactoryJAXRPC(), null);
                    break block14;
                }
                if (URN_JAXWS_CONFIG.equals(nsURI)) {
                    wsConfig = ConfigMetaDataParser.parse((InputStream)is);
                    break block14;
                }
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_CONFIG_NS", (Object[])new Object[]{nsURI}));
            }
            catch (JBossXBException e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_WHILE_PARSING", (Object[])new Object[0]), e);
            }
            catch (IOException e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_READ_CONFIG_FILE", (Object[])new Object[]{configURL}), e);
            }
            finally {
                block15: {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {
                            if (!this.log.isDebugEnabled()) break block15;
                            this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
            }
        }
        return wsConfig;
    }

    private String getNamespaceURI(URL configURL) {
        try {
            Element root = DOMUtils.parse((InputStream)configURL.openStream());
            return root.getNamespaceURI();
        }
        catch (IOException ex) {
            throw new WSException(ex);
        }
    }

    public CommonConfig getConfig(UnifiedVirtualFile vfsRoot, String configName, String configFile) {
        URL configURL;
        Object configRoot;
        CommonConfigJAXRPC config;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getConfig: [name=" + configName + ",url=" + configFile + "]"));
        }
        if (configName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONFIG_NAME_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONFIG_FILE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if ("META-INF/standard-jaxws-endpoint-config.xml".equals(configFile)) {
            try {
                ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
                SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
                ServerConfig sc = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class, cl)).getServerConfig();
                for (EndpointConfig config2 : sc.getEndpointConfigs()) {
                    if (!config2.getConfigName().equals(configName)) continue;
                    return config2;
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"Could not get server config");
            }
        }
        if ((config = (configRoot = this.parse(configURL = this.filenameToURL(vfsRoot, configFile))) instanceof ConfigRootJAXRPC ? ((ConfigRootJAXRPC)configRoot).getConfigByName(configName) : ((ConfigRoot)configRoot).getConfigByName(configName)) == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_CONFIG", (Object[])new Object[]{configName}));
        }
        return config;
    }

    private URL filenameToURL(UnifiedVirtualFile vfsRoot, String configFile) {
        URL configURL = null;
        try {
            configURL = vfsRoot.findChild(configFile).toURL();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (configURL == null) {
            try {
                configURL = new ResourceLoaderAdapter(this.loader).findChild(configFile).toURL();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (configURL == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_CONFIGFILE", (Object[])new Object[]{configFile}));
        }
        return configURL;
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

