/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractWithDescriptionsParser;
import org.jboss.metadata.ejb.parser.spec.AroundInvokeMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AroundTimeoutMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.IdMetaDataAttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.UnexpectedAttributeProcessor;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.AroundTimeoutMetaData;
import org.jboss.metadata.ejb.spec.AroundTimeoutsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.LifecycleCallbackMetaDataParser;

public class InterceptorMetaDataParser
extends AbstractWithDescriptionsParser<InterceptorMetaData> {
    private static final AttributeProcessor<IdMetaData> ATTRIBUTE_PROCESSOR = new IdMetaDataAttributeProcessor<Object>(UnexpectedAttributeProcessor.instance());
    public static final InterceptorMetaDataParser INSTANCE = new InterceptorMetaDataParser();

    @Override
    public InterceptorMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        InterceptorMetaData interceptor = new InterceptorMetaData();
        AttributeProcessorHelper.processAttributes(interceptor, reader, ATTRIBUTE_PROCESSOR);
        this.processElements(interceptor, reader);
        return interceptor;
    }

    @Override
    protected void processElement(InterceptorMetaData interceptor, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        EnvironmentRefsGroupMetaData jndiEnvRefGroup = interceptor.getJndiEnvironmentRefsGroup();
        if (jndiEnvRefGroup == null) {
            jndiEnvRefGroup = new EnvironmentRefsGroupMetaData();
            interceptor.setJndiEnvironmentRefsGroup(jndiEnvRefGroup);
        }
        if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)jndiEnvRefGroup)) {
            return;
        }
        switch (ejbJarElement) {
            case INTERCEPTOR_CLASS: {
                String interceptorClass = InterceptorMetaDataParser.getElementText((XMLStreamReader)reader);
                interceptor.setInterceptorClass(interceptorClass);
                return;
            }
            case AROUND_INVOKE: {
                AroundInvokesMetaData aroundInvokes = interceptor.getAroundInvokes();
                if (aroundInvokes == null) {
                    aroundInvokes = new AroundInvokesMetaData();
                    interceptor.setAroundInvokes(aroundInvokes);
                }
                AroundInvokeMetaData aroundInvoke = AroundInvokeMetaDataParser.INSTANCE.parse(reader);
                aroundInvokes.add(aroundInvoke);
                return;
            }
            case AROUND_TIMEOUT: {
                AroundTimeoutsMetaData aroundTimeouts = interceptor.getAroundTimeouts();
                if (aroundTimeouts == null) {
                    aroundTimeouts = new AroundTimeoutsMetaData();
                    interceptor.setAroundTimeouts(aroundTimeouts);
                }
                AroundTimeoutMetaData aroundTimeout = AroundTimeoutMetaDataParser.INSTANCE.parse(reader);
                aroundTimeouts.add(aroundTimeout);
                return;
            }
            case POST_ACTIVATE: {
                LifecycleCallbacksMetaData postActivates = interceptor.getPostActivates();
                if (postActivates == null) {
                    postActivates = new LifecycleCallbacksMetaData();
                    interceptor.setPostActivates(postActivates);
                }
                LifecycleCallbackMetaData postActivate = LifecycleCallbackMetaDataParser.parse((XMLStreamReader)reader);
                postActivates.add((Object)postActivate);
                return;
            }
            case PRE_PASSIVATE: {
                LifecycleCallbacksMetaData prePassivates = interceptor.getPrePassivates();
                if (prePassivates == null) {
                    prePassivates = new LifecycleCallbacksMetaData();
                    interceptor.setPrePassivates(prePassivates);
                }
                LifecycleCallbackMetaData prePassivate = LifecycleCallbackMetaDataParser.parse((XMLStreamReader)reader);
                prePassivates.add((Object)prePassivate);
                return;
            }
        }
        super.processElement(interceptor, reader);
    }
}

