/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.domain.client.api.deployment;

/**
 * Variant of a {@link DeploymentPlanBuilder} that exposes
 * directives that are only applicable when controlling how a {@link DeploymentSetPlan}
 * should be applied to one or more server groups.
 *
 * @author Brian Stansberry
 */
public interface ServerGroupDeploymentPlanBuilder extends DeploymentPlanBuilder {

    /**
     * Indicates that  all <code>deploy</code>, <code>undeploy</code> or
     * <code>replace</code> operations associated with the deployment set
     * should be rolled back on all servers in the current server group
     * in case of a failure in any of them.
     *
     * @return a builder that can continue building the overall deployment plan
     */
    RollbackDeploymentPlanBuilder withRollback();

    /**
     * Indicates the deployment actions in the {@link DeploymentSetPlan} should
     * be rolled out to the servers in the server group one server at a time.
     * If this directive is not set the actions may be concurrently applied to
     * servers in the server group.
     *
     * @return a builder that can continue building the overall deployment plan
     */
    ServerGroupDeploymentPlanBuilder rollingToServers();

    /**
     * Indicates that once the deployment actions in the {@link DeploymentSetPlan}
     * are applied to the servers in the current server group, they should then
     * be applied to the servers in the given server group.
     *
     * @param serverGroupName the name of the server group. Cannot be <code>null</code>
     *
     * @return a builder that can continue building the overall deployment plan
     */
    ServerGroupDeploymentPlanBuilder rollingToServerGroup(String serverGroupName);

    /**
     * Indicates that concurrent with applying the deployment actions in the {@link DeploymentSetPlan}
     * to the servers in the current server group, they should also be applied
     * to the servers in the given server group.
     *
     * @param serverGroupName the name of the server group. Cannot be <code>null</code>
     *
     * @return a builder that can continue building the overall deployment plan
     */
    ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName);

}
