/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.domain.client.impl.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.jboss.as.domain.client.api.deployment.ServerDeploymentPlanResult;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlanResult;

/**
 * Default implementation of {@link ServerGroupDeploymentPlanResult}.
 *
 * @author Brian Stansberry
 */
class ServerGroupDeploymentPlanResultImpl implements ServerGroupDeploymentPlanResult {

    private final String serverGroupName;
    private final Map<String, ServerDeploymentPlanResult> serverResults = new HashMap<String, ServerDeploymentPlanResult>();

    ServerGroupDeploymentPlanResultImpl(final String serverGroupName) {
        assert serverGroupName != null : "serverGroupName is null";
        this.serverGroupName = serverGroupName;
    }

    @Override
    public String getServerGroupName() {
        return serverGroupName;
    }

    @Override
    public Map<String, ServerDeploymentPlanResult> getServerResults() {
        return Collections.unmodifiableMap(serverResults);
    }

    ServerDeploymentPlanResult getServerResult(String server) {
        synchronized (serverResults) {
            return serverResults.get(server);
        }
    }

    void storeServerResult(String server, ServerDeploymentPlanResult result) {
        synchronized (serverResults) {
            serverResults.put(server, result);
        }
    }

}
