/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.api;

import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.domain.client.api.DomainUpdateApplier;
import org.jboss.as.domain.client.api.DomainUpdateResult;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.client.api.deployment.DomainDeploymentManager;
import org.jboss.as.domain.client.impl.DomainClientImpl;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModel;

public interface DomainClient
extends Closeable {
    public DomainModel getDomainModel();

    public List<String> getServerManagerNames();

    public List<DomainUpdateResult<?>> applyUpdates(List<AbstractDomainModelUpdate<?>> var1);

    public <R, P> void applyUpdate(AbstractDomainModelUpdate<R> var1, DomainUpdateApplier<R, P> var2, P var3);

    public byte[] addDeploymentContent(String var1, String var2, InputStream var3);

    public DomainDeploymentManager getDeploymentManager();

    public HostModel getHostModel(String var1);

    public List<HostUpdateResult<?>> applyHostUpdates(String var1, List<AbstractHostModelUpdate<?>> var2);

    public Map<ServerIdentity, ServerStatus> getServerStatuses();

    public ServerModel getServerModel(String var1, String var2);

    public ServerStatus startServer(String var1, String var2);

    public ServerStatus stopServer(String var1, String var2, long var3, TimeUnit var5);

    public ServerStatus restartServer(String var1, String var2, long var3, TimeUnit var5);

    public static class Factory {
        public static DomainClient create(InetAddress address, int port) {
            return new DomainClientImpl(address, port);
        }
    }
}

