/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.model.UpdateFailedException;

public class HostUpdateResult<R>
implements Serializable {
    private static final long serialVersionUID = 4320577243229764829L;
    private final boolean cancelled;
    private final boolean rolledBack;
    private final UpdateFailedException hostFailure;
    private final Map<ServerIdentity, R> serverResults;
    private final Map<ServerIdentity, Throwable> serverFailures;
    private final Set<ServerIdentity> serverCancellations;
    private final Set<ServerIdentity> serverTimeouts;
    private final Set<ServerIdentity> serverRollbacks;

    public HostUpdateResult() {
        this.cancelled = false;
        this.rolledBack = false;
        this.hostFailure = null;
        this.serverResults = null;
        this.serverFailures = null;
        this.serverCancellations = null;
        this.serverTimeouts = null;
        this.serverRollbacks = null;
    }

    public HostUpdateResult(boolean cancelled) {
        this.cancelled = cancelled;
        this.rolledBack = !cancelled;
        this.hostFailure = null;
        this.serverResults = null;
        this.serverFailures = null;
        this.serverCancellations = null;
        this.serverTimeouts = null;
        this.serverRollbacks = null;
    }

    public HostUpdateResult(UpdateFailedException hostFailure) {
        this.hostFailure = hostFailure;
        this.serverResults = null;
        this.serverFailures = null;
        this.serverCancellations = null;
        this.serverTimeouts = null;
        this.serverRollbacks = null;
        this.cancelled = false;
        this.rolledBack = false;
    }

    public HostUpdateResult(Map<ServerIdentity, R> serverResults, Map<ServerIdentity, Throwable> serverFailures, Set<ServerIdentity> serverCancellations, Set<ServerIdentity> serverTimeouts, Set<ServerIdentity> serverRollbacks) {
        this.hostFailure = null;
        this.serverResults = serverResults;
        this.serverFailures = serverFailures;
        this.serverCancellations = serverCancellations;
        this.serverTimeouts = serverTimeouts;
        this.serverRollbacks = serverRollbacks;
        this.cancelled = false;
        this.rolledBack = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public UpdateFailedException getHostFailure() {
        return this.hostFailure;
    }

    public Map<ServerIdentity, R> getServerResults() {
        return this.serverResults == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.serverResults);
    }

    public Map<ServerIdentity, Throwable> getServerFailures() {
        return this.serverFailures == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.serverFailures);
    }

    public Set<ServerIdentity> getServerCancellations() {
        return this.serverCancellations == null ? Collections.emptySet() : Collections.unmodifiableSet(this.serverCancellations);
    }

    public Set<ServerIdentity> getServerTimeouts() {
        return this.serverTimeouts == null ? Collections.emptySet() : Collections.unmodifiableSet(this.serverTimeouts);
    }

    public Set<ServerIdentity> getServerRollbacks() {
        return this.serverRollbacks == null ? Collections.emptySet() : Collections.unmodifiableSet(this.serverRollbacks);
    }

    public boolean isSuccess() {
        return !(this.cancelled || this.rolledBack || this.hostFailure != null || this.serverFailures != null && this.serverFailures.size() != 0 || this.serverCancellations != null && this.serverCancellations.size() != 0 || this.serverTimeouts != null && this.serverTimeouts.size() != 0 || this.serverRollbacks != null && this.serverRollbacks.size() != 0);
    }

    public HostUpdateResult<R> newWithAddedResult(ServerIdentity server, R result) {
        this.checkAllowServer();
        HashMap sr = this.serverResults == null ? new HashMap() : new HashMap<ServerIdentity, R>(this.serverResults);
        return new HostUpdateResult(sr, this.serverFailures, this.serverCancellations, this.serverTimeouts, this.serverRollbacks);
    }

    public HostUpdateResult<R> newWithAddedFailure(ServerIdentity server, Throwable failure) {
        this.checkAllowServer();
        HashMap<ServerIdentity, Throwable> sf = this.serverFailures == null ? new HashMap<ServerIdentity, Throwable>() : new HashMap<ServerIdentity, Throwable>(this.serverFailures);
        return new HostUpdateResult<R>(this.serverResults, sf, this.serverCancellations, this.serverTimeouts, this.serverRollbacks);
    }

    public HostUpdateResult<R> newWithAddedCancellation(ServerIdentity server) {
        this.checkAllowServer();
        HashSet<ServerIdentity> sc = this.serverCancellations == null ? new HashSet<ServerIdentity>() : new HashSet<ServerIdentity>(this.serverCancellations);
        return new HostUpdateResult<R>(this.serverResults, this.serverFailures, sc, this.serverTimeouts, this.serverRollbacks);
    }

    public HostUpdateResult<R> newWithAddedTimeout(ServerIdentity server) {
        this.checkAllowServer();
        HashSet<ServerIdentity> st = this.serverTimeouts == null ? new HashSet<ServerIdentity>() : new HashSet<ServerIdentity>(this.serverTimeouts);
        return new HostUpdateResult<R>(this.serverResults, this.serverFailures, this.serverCancellations, st, this.serverRollbacks);
    }

    public HostUpdateResult<R> newWithAddedRollback(ServerIdentity server) {
        this.checkAllowServer();
        HashSet<ServerIdentity> sr = this.serverRollbacks == null ? new HashSet<ServerIdentity>() : new HashSet<ServerIdentity>(this.serverRollbacks);
        return new HostUpdateResult<R>(this.serverResults, this.serverFailures, this.serverCancellations, this.serverTimeouts, sr);
    }

    private void checkAllowServer() {
        if (this.cancelled || this.rolledBack || this.hostFailure != null) {
            throw new IllegalStateException("Cannot add server results to an update that was not successfully applied to the server manager");
        }
    }
}

