/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentPlanResult;
import org.jboss.as.domain.client.api.deployment.DomainDeploymentManager;
import org.jboss.as.domain.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.domain.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.domain.client.impl.DomainClientImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentContentDistributor;
import org.jboss.as.domain.client.impl.deployment.InitialDeploymentPlanBuilderFactory;

class DomainDeploymentManagerImpl
implements DomainDeploymentManager {
    private final DomainClientImpl client;
    private final DeploymentContentDistributor contentDistributor;

    DomainDeploymentManagerImpl(DomainClientImpl client) {
        assert (client != null) : "client is null";
        this.client = client;
        this.contentDistributor = new DeploymentContentDistributor(){

            @Override
            public byte[] distributeDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
                boolean unique = DomainDeploymentManagerImpl.this.client.isDeploymentNameUnique(name);
                if (!unique) {
                    throw new DuplicateDeploymentNameException(name, false);
                }
                return DomainDeploymentManagerImpl.this.client.addDeploymentContent(name, runtimeName, stream);
            }

            @Override
            public byte[] distributeReplacementDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
                return DomainDeploymentManagerImpl.this.client.addDeploymentContent(name, runtimeName, stream);
            }
        };
    }

    @Override
    public Future<DeploymentPlanResult> execute(DeploymentPlan plan) {
        return this.client.execute(plan);
    }

    @Override
    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder(this.contentDistributor);
    }
}

