/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jboss.as.domain.client.api.DomainUpdateApplier;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.impl.DomainClientImpl;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.UpdateResultHandler;

class DomainUpdateApplierContextImpl<R>
implements DomainUpdateApplier.Context<R> {
    private final List<ServerIdentity> servers = new ArrayList<ServerIdentity>();
    private final DomainClientImpl client;
    private final AbstractServerModelUpdate<R> update;
    private Future<Void> responseFuture;
    private boolean cancelled;

    static <R> DomainUpdateApplier.Context<R> createDomainUpdateApplierContext(DomainClientImpl client, List<ServerIdentity> servers, AbstractServerModelUpdate<R> update) {
        return new DomainUpdateApplierContextImpl<R>(client, servers, update);
    }

    DomainUpdateApplierContextImpl(DomainClientImpl client, List<ServerIdentity> servers, AbstractServerModelUpdate<R> update) {
        assert (client != null) : "client is null";
        assert (update != null) : "update is null";
        this.client = client;
        this.update = update;
        if (servers != null) {
            this.servers.addAll(servers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> void apply(ServerIdentity server, UpdateResultHandler<R, P> resultHandler, P param) {
        if (!this.servers.contains(server)) {
            throw new IllegalArgumentException("Unknown server " + server);
        }
        DomainUpdateApplierContextImpl domainUpdateApplierContextImpl = this;
        synchronized (domainUpdateApplierContextImpl) {
            if (!this.cancelled) {
                this.responseFuture = this.client.applyUpdateToServer(this.update, server, resultHandler, param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        DomainUpdateApplierContextImpl domainUpdateApplierContextImpl = this;
        synchronized (domainUpdateApplierContextImpl) {
            this.cancelled = true;
            if (this.responseFuture != null) {
                this.responseFuture.cancel(true);
            }
        }
    }

    @Override
    public Collection<ServerIdentity> getAffectedServers() {
        return Collections.unmodifiableList(this.servers);
    }
}

