/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.model.UpdateFailedException;

public class HostUpdateApplierResponse
implements Serializable {
    private static final long serialVersionUID = -429776145137267595L;
    private final UpdateFailedException hostFailure;
    private final List<ServerIdentity> servers = new ArrayList<ServerIdentity>();
    private final boolean cancelled;
    private final boolean rolledBack;

    public HostUpdateApplierResponse(boolean cancelled) {
        this.cancelled = cancelled;
        this.rolledBack = !cancelled;
        this.hostFailure = null;
    }

    public HostUpdateApplierResponse(UpdateFailedException hostFailure) {
        this.hostFailure = hostFailure;
        this.cancelled = false;
        this.rolledBack = false;
    }

    public HostUpdateApplierResponse(List<ServerIdentity> servers) {
        this.hostFailure = null;
        if (servers != null) {
            this.servers.addAll(servers);
        }
        this.cancelled = false;
        this.rolledBack = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public UpdateFailedException getHostFailure() {
        return this.hostFailure;
    }

    public List<ServerIdentity> getServers() {
        return Collections.unmodifiableList(this.servers);
    }
}

