/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.util.Map;
import java.util.UUID;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentPlanResult;
import org.jboss.as.domain.client.api.deployment.DeploymentSetPlanResult;
import org.jboss.as.domain.client.api.deployment.InvalidDeploymentPlanException;

public class DeploymentPlanResultImpl
implements DeploymentPlanResult {
    private final DeploymentPlan plan;
    private final InvalidDeploymentPlanException idpe;
    private final Map<UUID, DeploymentSetPlanResult> setResults;

    public DeploymentPlanResultImpl(DeploymentPlan plan, Map<UUID, DeploymentSetPlanResult> setResults) {
        if (plan == null) {
            throw new IllegalArgumentException("plan is null");
        }
        if (setResults == null) {
            throw new IllegalArgumentException("setResults is null");
        }
        this.plan = plan;
        this.setResults = setResults;
        this.idpe = null;
    }

    public DeploymentPlanResultImpl(DeploymentPlan plan, InvalidDeploymentPlanException invalidPlanException) {
        if (plan == null) {
            throw new IllegalArgumentException("plan is null");
        }
        if (invalidPlanException == null) {
            throw new IllegalArgumentException("invalidPlanException is null");
        }
        this.plan = plan;
        this.setResults = null;
        this.idpe = invalidPlanException;
    }

    @Override
    public DeploymentSetPlanResult getDeploymentSetResult(UUID deploymentSet) throws InvalidDeploymentPlanException {
        if (this.idpe != null) {
            throw this.idpe;
        }
        return this.setResults.get(deploymentSet);
    }

    @Override
    public UUID getId() {
        return this.plan.getId();
    }

    @Override
    public DeploymentPlan getDeploymentPlan() {
        return this.plan;
    }

    @Override
    public InvalidDeploymentPlanException getInvalidDeploymentPlanException() {
        return this.idpe;
    }

    @Override
    public boolean isValid() {
        return this.idpe == null;
    }
}

