/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import org.jboss.as.domain.client.api.deployment.RollbackDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlan;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.domain.client.impl.deployment.DeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentSetPlanImpl;
import org.jboss.as.domain.client.impl.deployment.InitialDeploymentSetBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.RollbackDeploymentPlanBuilderImpl;

class ServerGroupDeploymentPlanBuilderImpl
extends InitialDeploymentSetBuilderImpl
implements ServerGroupDeploymentPlanBuilder {
    ServerGroupDeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan, boolean replace) {
        super(existing, setPlan, replace);
    }

    @Override
    public RollbackDeploymentPlanBuilder withRollback() {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = setPlan.getLatestServerGroupDeploymentPlan();
        if (groupPlan == null) {
            throw new IllegalStateException(String.format("No %s is configured", ServerGroupDeploymentPlan.class.getSimpleName()));
        }
        groupPlan = groupPlan.createRollback();
        setPlan = setPlan.storeServerGroup(groupPlan);
        return new RollbackDeploymentPlanBuilderImpl(this, setPlan, true);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder rollingToServers() {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = setPlan.getLatestServerGroupDeploymentPlan();
        if (groupPlan == null) {
            throw new IllegalStateException(String.format("No %s is configured", ServerGroupDeploymentPlan.class.getSimpleName()));
        }
        groupPlan = groupPlan.createRollingToServers();
        setPlan = setPlan.storeServerGroup(groupPlan);
        return new ServerGroupDeploymentPlanBuilderImpl(this, setPlan, true);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder rollingToServerGroup(String serverGroupName) {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = new ServerGroupDeploymentPlan(serverGroupName);
        setPlan = setPlan.storeRollToServerGroup(groupPlan);
        return new ServerGroupDeploymentPlanBuilderImpl(this, setPlan, true);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = new ServerGroupDeploymentPlan(serverGroupName);
        setPlan = setPlan.storeServerGroup(groupPlan);
        return new ServerGroupDeploymentPlanBuilderImpl(this, setPlan, true);
    }
}

