/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.io.Serializable;
import java.util.UUID;
import org.jboss.as.domain.client.api.RollbackCancelledException;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerUpdateResult;
import org.jboss.as.model.UpdateResultHandlerResponse;

class ServerUpdateResultImpl<R>
implements ServerUpdateResult<R>,
Serializable {
    private static final long serialVersionUID = 5879115765933810032L;
    private final UUID actionId;
    private final ServerIdentity serverId;
    private final UpdateResultHandlerResponse<R> urhr;
    private UpdateResultHandlerResponse<?> rollbackResult;

    ServerUpdateResultImpl(UUID actionId, ServerIdentity serverId, UpdateResultHandlerResponse<R> urhr) {
        assert (actionId != null) : "actionId is null";
        assert (serverId != null) : "serverId is null";
        assert (urhr != null) : "urhr is null";
        this.actionId = actionId;
        this.serverId = serverId;
        this.urhr = urhr;
    }

    @Override
    public Throwable getFailureResult() {
        return this.urhr.getFailureResult();
    }

    @Override
    public ServerIdentity getServerIdentity() {
        return this.serverId;
    }

    @Override
    public R getSuccessResult() {
        return (R)this.urhr.getSuccessResult();
    }

    @Override
    public UUID getUpdateActionId() {
        return this.actionId;
    }

    @Override
    public boolean isCancelled() {
        return this.urhr.isCancelled();
    }

    @Override
    public boolean isRolledBack() {
        return this.rollbackResult != null || this.urhr.isRolledBack();
    }

    @Override
    public boolean isTimedOut() {
        return this.urhr.isTimedOut();
    }

    void markRolledBack(UpdateResultHandlerResponse<?> rollbackResult) {
        this.rollbackResult = rollbackResult;
    }

    @Override
    public boolean isServerRestarted() {
        return this.urhr.isServerRestarted();
    }

    @Override
    public Throwable getRollbackFailure() {
        if (this.rollbackResult == null) {
            return null;
        }
        if (this.rollbackResult.isCancelled()) {
            return new RollbackCancelledException("Rollback was cancelled");
        }
        if (this.rollbackResult.isRolledBack()) {
            return new RollbackCancelledException("Rollback was itself rolled back");
        }
        if (this.rollbackResult.isTimedOut()) {
            return new RollbackCancelledException("Rollback timed out");
        }
        return this.rollbackResult.getFailureResult();
    }
}

