/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractDeploymentUploadHandler
implements OperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");
    private static final String[] EMPTY = new String[0];
    private final DeploymentRepository deploymentRepository;

    protected AbstractDeploymentUploadHandler(DeploymentRepository deploymentRepository) {
        this.deploymentRepository = deploymentRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        if (this.deploymentRepository != null) {
            try {
                InputStream is = this.getContentInputStream(context, operation);
                try {
                    byte[] hash = this.deploymentRepository.addDeploymentContent(is);
                    resultHandler.handleResultFragment(EMPTY, new ModelNode().set(hash));
                }
                finally {
                    AbstractDeploymentUploadHandler.safeClose(is);
                }
            }
            catch (IOException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        }
        resultHandler.handleResultComplete();
        return new BasicOperationResult();
    }

    protected abstract InputStream getContentInputStream(OperationContext var1, ModelNode var2) throws OperationFailedException;

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception closing input stream", (Throwable)e);
            }
        }
    }
}

