/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private static final List<String> VALID_DEPLOYMENT_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "hash", "url");
    private final DeploymentRepository deploymentRepository;
    private final boolean isMaster;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address, ModelNode state) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("runtime-name").set(state.get("runtime-name"));
        op.get("hash").set(state.get("hash"));
        return op;
    }

    public DeploymentAddHandler(DeploymentRepository deploymentRepository, boolean isMaster) {
        this.deploymentRepository = deploymentRepository;
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        this.validator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.isMaster = isMaster;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation((Locale)locale, (boolean)false);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        byte[] hash;
        String runtimeName;
        this.validator.validate(operation);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        String string = runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        if (this.tooManyDeploymentParametersDefined(operation)) {
            throw this.createFailureException("Only allowed one of the following parameters is allowed %s.", VALID_DEPLOYMENT_PARAMETERS);
        }
        if (operation.hasDefined("hash")) {
            hash = operation.get("hash").asBytes();
        } else if (this.hasValidDeploymentParameterDefined(operation)) {
            if (!this.isMaster) {
                throw this.createFailureException("A slave domain controller cannot accept deployment content uploads");
            }
            try {
                hash = DeploymentUploadUtil.storeDeploymentContent((OperationAttachments)context, operation, this.deploymentRepository);
            }
            catch (IOException e) {
                throw this.createFailureException(e.toString());
            }
        } else {
            throw this.createFailureException("None of the following parameters were defined %s.", VALID_DEPLOYMENT_PARAMETERS);
        }
        if (this.isMaster && !this.deploymentRepository.hasDeploymentContent(hash)) {
            throw this.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
        }
        ModelNode subModel = context.getSubModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(runtimeName);
        subModel.get("hash").set(hash);
        resultHandler.handleResultComplete();
        return new BasicOperationResult(Util.getResourceRemoveOperation((ModelNode)operation.get("address")));
    }

    private boolean hasValidDeploymentParameterDefined(ModelNode operation) {
        for (String s : VALID_DEPLOYMENT_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    private boolean tooManyDeploymentParametersDefined(ModelNode operation) {
        int count = 0;
        for (String s : VALID_DEPLOYMENT_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            ++count;
        }
        return count > 1;
    }

    private OperationFailedException createFailureException(String format, Object ... params) {
        return this.createFailureException(String.format(format, params));
    }

    private OperationFailedException createFailureException(Throwable cause, String format, Object ... params) {
        return this.createFailureException(cause, String.format(format, params));
    }

    private OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }

    private OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode().set(msg));
    }
}

