/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadStreamAttachmentHandler
extends AbstractDeploymentUploadHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "upload-deployment-stream";
    private final ParametersValidator streamValidator = new ParametersValidator();

    public DeploymentUploadStreamAttachmentHandler(DeploymentRepository repository) {
        super(repository);
        this.streamValidator.registerValidator("input-stream-index", (ParameterValidator)new IntRangeValidator(0));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getUploadDeploymentStreamAttachmentOperation((Locale)locale);
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        this.streamValidator.validate(operation);
        int streamIndex = operation.get("input-stream-index").asInt();
        int maxIndex = operationContext.getInputStreams().size() - 1;
        if (streamIndex > maxIndex) {
            throw new OperationFailedException(new ModelNode().set(String.format("Invalid 'input-stream-index' value: %d, the maximum index is %d", streamIndex, maxIndex)));
        }
        InputStream in = (InputStream)operationContext.getInputStreams().get(streamIndex);
        if (in == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("Null stream at index %s", streamIndex)));
        }
        return in;
    }
}

