/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadUtil {
    private DeploymentUploadUtil() {
    }

    public static byte[] storeDeploymentContent(OperationAttachments context, ModelNode operation, DeploymentRepository deploymentRepository) throws IOException, OperationFailedException {
        InputStream in = DeploymentUploadUtil.getContents(context, operation);
        return deploymentRepository.addDeploymentContent(in);
    }

    private static InputStream getContents(OperationAttachments context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (operation.hasDefined("input-stream-index")) {
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > context.getInputStreams().size() - 1) {
                IllegalArgumentException e = new IllegalArgumentException("Invalid input-stream-index=" + streamIndex + ", the maximum index is " + (context.getInputStreams().size() - 1));
                throw DeploymentUploadUtil.createFailureException(e, message);
            }
            message = "Null stream at index " + streamIndex;
            in = (InputStream)context.getInputStreams().get(streamIndex);
        } else if (operation.hasDefined("bytes")) {
            in = new ByteArrayInputStream(operation.get("bytes").asBytes());
            message = "Invalid byte stream.";
        } else if (operation.hasDefined("url")) {
            String urlSpec = operation.get("url").asString();
            try {
                message = "Invalid url stream.";
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw DeploymentUploadUtil.createFailureException(message);
            }
            catch (IOException e) {
                throw DeploymentUploadUtil.createFailureException(message);
            }
        }
        if (in == null) {
            throw DeploymentUploadUtil.createFailureException(message);
        }
        return in;
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }

    private static OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode().set(msg));
    }
}

