/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Locale;
import java.util.NoSuchElementException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.descriptions.ServerGroupDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerGroupAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final ServerGroupAddHandler INSTANCE = new ServerGroupAddHandler();
    private final ParametersValidator validator = new ParametersValidator();

    private ServerGroupAddHandler() {
        this.validator.registerValidator("profile", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("socket-binding-group", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("socket-binding-port-offset", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true, false));
        this.validator.registerValidator("jvm", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        String profile = operation.require("profile").asString();
        try {
            context.getRootResource().navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profile)}));
        }
        catch (NoSuchElementException e) {
            throw new OperationFailedException(new ModelNode().set(String.format("Unknown %s %s", "profile", profile)));
        }
        model.get("profile").set(profile);
        if (operation.hasDefined("socket-binding-group")) {
            String socketBindingGroup = operation.get("socket-binding-group").asString();
            try {
                context.getRootResource().navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroup)}));
            }
            catch (NoSuchElementException e) {
                throw new OperationFailedException(new ModelNode().set(String.format("Unknown %s %s", "socket-binding-group", socketBindingGroup)));
            }
            model.get("socket-binding-group").set(socketBindingGroup);
        }
        if (operation.hasDefined("socket-binding-port-offset")) {
            model.get("socket-binding-port-offset").set(operation.get("socket-binding-port-offset"));
        }
        if (operation.hasDefined("jvm")) {
            model.get("jvm").set(operation.get("jvm").asString(), new ModelNode());
        } else {
            model.get("jvm");
        }
        model.get("system-property");
        model.get("deployment");
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    public ModelNode getModelDescription(Locale locale) {
        return ServerGroupDescription.getServerGroupAdd(locale);
    }
}

