/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.multipart;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultipartHeader {
    private static final String HEADER_SPLIT_TOKEN = "\\r\\n";
    private static final Pattern CONTENT_DISPOSTION = Pattern.compile("Content-Disposition:\\s(.*)");
    private static final Pattern CONTENT_TYPE = Pattern.compile("Content-Type:\\s(.*)");
    private final String contentType;
    private final String contentDisposition;

    public MultipartHeader(byte[] header) {
        String[] headerLines = new String(header).split(HEADER_SPLIT_TOKEN);
        this.contentDisposition = this.find(headerLines, CONTENT_DISPOSTION, 1);
        this.contentType = this.find(headerLines, CONTENT_TYPE, 1);
    }

    private String find(String[] headerLines, Pattern pattern, int groupId) {
        String value = null;
        for (String line : headerLines) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            value = m.group(groupId);
        }
        return value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }
}

