/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class UserLdapCallbackHandler
implements Service<UserLdapCallbackHandler>,
DomainCallbackHandler {
    public static final String SERVICE_SUFFIX = "ldap";
    private static final Class[] supportedCallbacks = new Class[]{RealmCallback.class, NameCallback.class, VerifyPasswordCallback.class, AuthorizeCallback.class};
    private static final String DEFAULT_USER_DN = "dn";
    private final InjectedValue<ConnectionManager> connectionManager = new InjectedValue();
    private final String baseDn;
    private final String usernameAttribute;
    private final boolean recursive;
    private final String userDn;
    protected final int searchTimeLimit = 10000;

    public UserLdapCallbackHandler(ModelNode userLdap) {
        this.baseDn = userLdap.require("base-dn").asString();
        this.usernameAttribute = userLdap.require("username-attribute").asString();
        this.recursive = userLdap.has("recursive") ? userLdap.require("recursive").asBoolean() : false;
        this.userDn = userLdap.has("user-dn") ? userLdap.require("user-dn").asString() : DEFAULT_USER_DN;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public UserLdapCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    @Override
    public Class[] getSupportedCallbacks() {
        return supportedCallbacks;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
            AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
            String authenticationId = acb.getAuthenticationID();
            String authorizationId = acb.getAuthorizationID();
            acb.setAuthorized("".equals(authorizationId) || authenticationId.equals(authorizationId));
            return;
        }
        ConnectionManager connectionManager = (ConnectionManager)this.connectionManager.getValue();
        String username = null;
        VerifyPasswordCallback verifyPasswordCallback = null;
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                username = ((NameCallback)current).getDefaultName();
                continue;
            }
            if (current instanceof RealmCallback) continue;
            if (current instanceof VerifyPasswordCallback) {
                verifyPasswordCallback = (VerifyPasswordCallback)current;
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
        if (username == null || username.length() == 0) {
            throw new IOException("No username provided.");
        }
        if (verifyPasswordCallback == null) {
            throw new IOException("No password to verify.");
        }
        InitialDirContext searchContext = null;
        InitialDirContext userContext = null;
        NamingEnumeration<SearchResult> searchEnumeration = null;
        try {
            Attribute dn;
            searchContext = (InitialDirContext)connectionManager.getConnection();
            SearchControls searchControls = new SearchControls();
            if (this.recursive) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            searchControls.setReturningAttributes(new String[]{this.userDn});
            searchControls.setTimeLimit(10000);
            Object[] filterArguments = new Object[]{username};
            String filter = "(" + this.usernameAttribute + "={0})";
            searchEnumeration = searchContext.search(this.baseDn, filter, filterArguments, searchControls);
            if (!searchEnumeration.hasMore()) {
                throw new IOException("User '" + username + "' not found in directory.");
            }
            String distinguishedUserDN = null;
            SearchResult result = searchEnumeration.next();
            Attributes attributes = result.getAttributes();
            if (attributes != null && (dn = attributes.get(this.userDn)) != null) {
                distinguishedUserDN = (String)dn.get();
            }
            if (distinguishedUserDN == null) {
                if (result.isRelative()) {
                    distinguishedUserDN = result.getName() + ("".equals(this.baseDn) ? "" : "," + this.baseDn);
                } else {
                    throw new NamingException("Can't follow referal for authentication: " + result.getName());
                }
            }
            if ((userContext = (InitialDirContext)connectionManager.getConnection(distinguishedUserDN, verifyPasswordCallback.getPassword())) != null) {
                verifyPasswordCallback.setVerified(true);
            }
            this.safeClose(searchEnumeration);
            this.safeClose(searchContext);
            this.safeClose(userContext);
        }
        catch (Exception e) {
            try {
                throw new IOException("Unable to perform verification", e);
            }
            catch (Throwable throwable) {
                this.safeClose(searchEnumeration);
                this.safeClose(searchContext);
                this.safeClose(userContext);
                throw throwable;
            }
        }
    }

    private void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void safeClose(NamingEnumeration ne) {
        if (ne != null) {
            try {
                ne.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

