/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class AddPropertiesUser {
    private static final String[] badUsernames = new String[]{"admin", "administrator", "root"};
    private static final String DEFAULT_REALM = "ManagementRealm";
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String COMMENT = "#";
    private Console theConsole = System.console();
    private List<File> propertiesFiles;
    private Set<String> knownUsers;
    private State nextState;

    private AddPropertiesUser() {
        if (this.theConsole == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        this.nextState = new PropertyFileFinder();
    }

    private AddPropertiesUser(String user, char[] password, String realm) {
        if (this.theConsole == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        Values values = new Values();
        values.nonInteractive = true;
        values.userName = user;
        Values.access$402(values, password);
        values.realm = realm;
        this.nextState = new PropertyFileFinder(values);
    }

    private AddPropertiesUser(String user, char[] password) {
        this(user, password, DEFAULT_REALM);
    }

    private void run() {
        while ((this.nextState = this.nextState.execute()) != null) {
        }
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            new AddPropertiesUser(args[0], args[1].toCharArray(), args[2]).run();
        } else if (args.length == 2) {
            new AddPropertiesUser(args[0], args[1].toCharArray()).run();
        } else {
            new AddPropertiesUser().run();
        }
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static interface State {
        public State execute();
    }

    private class Values {
        private boolean nonInteractive = false;
        private String realm;
        private String userName;
        private char[] password;

        private Values() {
        }

        static /* synthetic */ char[] access$402(Values x0, char[] x1) {
            x0.password = x1;
            return x1;
        }
    }

    private class ErrorState
    implements State {
        private final State nextState;
        private final String errorMessage;

        private ErrorState(String errorMessage) {
            this(errorMessage, (State)null);
        }

        private ErrorState(String errorMessage, State nextState) {
            this.errorMessage = errorMessage;
            this.nextState = nextState;
        }

        @Override
        public State execute() {
            AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            AddPropertiesUser.this.theConsole.printf(" * ", new Object[0]);
            AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.errorHeader(), new Object[0]);
            AddPropertiesUser.this.theConsole.printf(" * ", new Object[0]);
            AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            AddPropertiesUser.this.theConsole.printf(this.errorMessage, new Object[0]);
            AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            return this.nextState;
        }
    }

    private class AddUser
    implements State {
        private final Values values;

        private AddUser(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            String entry;
            try {
                String hash = new UsernamePasswordHashUtil().generateHashedHexURP(this.values.userName, this.values.realm, this.values.password);
                entry = this.values.userName + "=" + hash;
            }
            catch (NoSuchAlgorithmException e) {
                return new ErrorState(e.getMessage());
            }
            for (File current : AddPropertiesUser.this.propertiesFiles) {
                try {
                    this.append(entry, current);
                    AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.addedUser(this.values.userName, current.getCanonicalPath()), new Object[0]);
                    AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                }
                catch (IOException e) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.unableToAddUser(current.getAbsolutePath(), e.getMessage()));
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void append(String entry, File toFile) throws IOException {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                fw = new FileWriter(toFile, true);
                bw = new BufferedWriter(fw);
                bw.append(entry);
                bw.newLine();
            }
            catch (Throwable throwable) {
                AddPropertiesUser.safeClose(bw);
                AddPropertiesUser.safeClose(fw);
                throw throwable;
            }
            AddPropertiesUser.safeClose(bw);
            AddPropertiesUser.safeClose(fw);
        }
    }

    private class ConfirmationChoice
    implements State {
        private final String message;
        private final String prompt;
        private final State yesState;
        private final State noState;
        private static final int YES = 0;
        private static final int NO = 1;
        private static final int INVALID = 2;

        private ConfirmationChoice(String message, String prompt, State yesState, State noState) {
            this.message = message;
            this.prompt = prompt;
            this.yesState = yesState;
            this.noState = noState;
        }

        @Override
        public State execute() {
            if (this.message != null) {
                AddPropertiesUser.this.theConsole.printf(this.message, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            }
            AddPropertiesUser.this.theConsole.printf(this.prompt, new Object[0]);
            String temp = AddPropertiesUser.this.theConsole.readLine(AddPropertiesUser.SPACE, new Object[0]);
            switch (this.convertResponse(temp)) {
                case 0: {
                    return this.yesState;
                }
                case 1: {
                    return this.noState;
                }
            }
            return new ErrorState(DomainManagementMessages.MESSAGES.invalidConfirmationResponse(), this);
        }

        private int convertResponse(String response) {
            if (response != null) {
                String temp = response.toLowerCase();
                if ("yes".equals(temp) || "y".equals(temp)) {
                    return 0;
                }
                if ("no".equals(temp) || "n".equals(temp)) {
                    return 1;
                }
            }
            return 2;
        }
    }

    private class DuplicateUserCheckState
    implements State {
        private Values values;

        private DuplicateUserCheckState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            State continuingState;
            if (AddPropertiesUser.this.knownUsers.contains(this.values.userName)) {
                PromptNewUserState continuing = this.values.nonInteractive ? null : new PromptNewUserState(this.values);
                return new ErrorState(DomainManagementMessages.MESSAGES.duplicateUser(this.values.userName), continuing);
            }
            AddUser addState = new AddUser(this.values);
            if (this.values.nonInteractive) {
                continuingState = addState;
            } else {
                String message = DomainManagementMessages.MESSAGES.aboutToAddUser(this.values.userName, this.values.realm);
                String prompt = DomainManagementMessages.MESSAGES.isCorrectPrompt();
                continuingState = new ConfirmationChoice(message, prompt, addState, new PromptNewUserState(this.values));
            }
            return continuingState;
        }
    }

    private class WeakCheckState
    implements State {
        private Values values;

        private WeakCheckState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            PromptNewUserState retryState;
            PromptNewUserState promptNewUserState = retryState = this.values.nonInteractive ? null : new PromptNewUserState(this.values);
            if (Arrays.equals(this.values.userName.toCharArray(), this.values.password)) {
                return new ErrorState(DomainManagementMessages.MESSAGES.usernamePasswordMatch(), retryState);
            }
            for (char currentChar : this.values.userName.toCharArray()) {
                if (Character.isLetter(currentChar) || Character.isDigit(currentChar)) continue;
                return new ErrorState(DomainManagementMessages.MESSAGES.usernameNotAlphaNumeric(), retryState);
            }
            boolean weakUserName = false;
            for (String current : badUsernames) {
                if (!current.equals(this.values.userName.toLowerCase())) continue;
                weakUserName = true;
                break;
            }
            DuplicateUserCheckState continuingState = new DuplicateUserCheckState(this.values);
            if (weakUserName && !this.values.nonInteractive) {
                String message = DomainManagementMessages.MESSAGES.usernameEasyToGuess(this.values.userName);
                String prompt = DomainManagementMessages.MESSAGES.sureToAddUser(this.values.userName);
                PromptNewUserState noState = new PromptNewUserState(this.values);
                return new ConfirmationChoice(message, prompt, continuingState, noState);
            }
            return continuingState;
        }
    }

    private class PromptNewUserState
    implements State {
        private final Values values;

        PromptNewUserState() {
            this.values = new Values();
            this.values.realm = AddPropertiesUser.DEFAULT_REALM;
        }

        PromptNewUserState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            if (!this.values.nonInteractive) {
                String existingUsername;
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.enterNewUserDetails(), new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                Values.access$402(this.values, null);
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.realmPrompt(this.values.realm), new Object[0]);
                String temp = AddPropertiesUser.this.theConsole.readLine(" : ", new Object[0]);
                if (temp == null) {
                    AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                    return null;
                }
                if (temp.length() > 0) {
                    this.values.realm = temp;
                }
                String usernamePrompt = (existingUsername = this.values.userName) == null ? DomainManagementMessages.MESSAGES.usernamePrompt() : DomainManagementMessages.MESSAGES.usernamePrompt(existingUsername);
                AddPropertiesUser.this.theConsole.printf(usernamePrompt, new Object[0]);
                temp = AddPropertiesUser.this.theConsole.readLine(" : ", new Object[0]);
                if (temp != null && temp.length() > 0) {
                    existingUsername = temp;
                }
                if (temp == null || existingUsername == null || existingUsername.length() == 0) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.noUsernameExiting());
                }
                this.values.userName = existingUsername;
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordPrompt(), new Object[0]);
                char[] tempChar = AddPropertiesUser.this.theConsole.readPassword(" : ", new Object[0]);
                if (tempChar == null || tempChar.length == 0) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.noPasswordExiting());
                }
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordConfirmationPrompt(), new Object[0]);
                char[] secondTempChar = AddPropertiesUser.this.theConsole.readPassword(" : ", new Object[0]);
                if (secondTempChar == null) {
                    secondTempChar = new char[]{};
                }
                if (!Arrays.equals(tempChar, secondTempChar)) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.passwordMisMatch(), this);
                }
                Values.access$402(this.values, tempChar);
            }
            return new WeakCheckState(this.values);
        }
    }

    private class PropertyFileFinder
    implements State {
        private final Values values;

        private PropertyFileFinder() {
            this.values = null;
        }

        private PropertyFileFinder(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            File domainProps;
            String jbossHome = System.getenv("JBOSS_HOME");
            if (jbossHome == null) {
                return new ErrorState(DomainManagementMessages.MESSAGES.jbossHomeNotSet());
            }
            ArrayList<File> foundFiles = new ArrayList<File>(2);
            File standaloneProps = new File(jbossHome + "/standalone/configuration/mgmt-users.properties");
            if (standaloneProps.exists()) {
                foundFiles.add(standaloneProps);
            }
            if ((domainProps = new File(jbossHome + "/domain/configuration/mgmt-users.properties")).exists()) {
                foundFiles.add(domainProps);
            }
            if (foundFiles.size() == 0) {
                return new ErrorState(DomainManagementMessages.MESSAGES.mgmtUsersPropertiesNotFound());
            }
            AddPropertiesUser.this.propertiesFiles = foundFiles;
            HashSet<String> foundUsers = new HashSet<String>();
            for (File current : AddPropertiesUser.this.propertiesFiles) {
                try {
                    foundUsers.addAll(this.loadUserNames(current));
                }
                catch (IOException e) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.unableToLoadUsers(current.getAbsolutePath(), e.getMessage()));
                }
            }
            AddPropertiesUser.this.knownUsers = foundUsers;
            if (this.values == null) {
                return new PromptNewUserState();
            }
            return new PromptNewUserState(this.values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> loadUserNames(File file) throws IOException {
            Set<String> set;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                Properties tempProps = new Properties();
                tempProps.load(fis);
                set = tempProps.stringPropertyNames();
            }
            catch (Throwable throwable) {
                AddPropertiesUser.safeClose(fis);
                throw throwable;
            }
            AddPropertiesUser.safeClose(fis);
            return set;
        }
    }
}

