/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.dmr.ModelNode;

class AuthenticationValidatingHandler
implements OperationStepHandler {
    static final AuthenticationValidatingHandler INSTANCE = new AuthenticationValidatingHandler();

    static ModelNode createOperation(ModelNode operationToValidate) {
        PathAddress pa = PathAddress.pathAddress((ModelNode)operationToValidate.require("address"));
        PathAddress realmPA = null;
        for (int i = pa.size() - 1; i > 0; ++i) {
            PathElement pe = pa.getElement(i);
            if (!"security-realm".equals(pe.getKey())) continue;
            realmPA = pa.subAddress(0, i + 1);
            break;
        }
        assert (realmPA != null) : "operationToValidate did not have an address that included a security-realm";
        return Util.getEmptyOperation((String)"validate-authentication", (ModelNode)realmPA.toModelNode());
    }

    private AuthenticationValidatingHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        int max;
        String realmName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set children = resource.getChildrenNames("authentication");
        int n = max = children.contains("truststore") ? 2 : 1;
        if (children.size() > max) {
            HashSet<String> invalid = new HashSet<String>(children);
            invalid.remove("truststore");
            throw DomainManagementMessages.MESSAGES.multipleAuthenticationMechanismsDefined(realmName, invalid);
        }
        if (children.size() == 0) {
            throw DomainManagementMessages.MESSAGES.noAuthenticationDefined(realmName);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

