/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.ServerSecurityManager;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.ClientCertCallbackHandler;
import org.jboss.as.domain.management.security.FileKeystoreService;
import org.jboss.as.domain.management.security.JaasCallbackHandler;
import org.jboss.as.domain.management.security.LocalCallbackHandlerService;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.PlugInAuthenticationCallbackHandler;
import org.jboss.as.domain.management.security.PlugInLoaderService;
import org.jboss.as.domain.management.security.PlugInSubjectSupplemental;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesSubjectSupplemental;
import org.jboss.as.domain.management.security.SSLIdentityService;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SecurityRealmAddHandler
implements OperationStepHandler {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void installServices(OperationContext context, String realmName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode plugIns = model.hasDefined("plug-in") ? model.get("plug-in") : null;
        ModelNode authentication = model.hasDefined("authentication") ? model.get("authentication") : null;
        ModelNode authorization = model.hasDefined("authorization") ? model.get("authorization") : null;
        ModelNode serverIdentities = model.hasDefined("server-identity") ? model.get("server-identity") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        SecurityRealmService securityRealmService = new SecurityRealmService(realmName);
        ServiceName realmServiceName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName, (Service)securityRealmService);
        ServiceName plugInLoaderName = null;
        ServiceName authenticationName = null;
        ServiceName authorizationName = null;
        ModelNode authTruststore = null;
        if (plugIns != null) {
            plugInLoaderName = this.addPlugInLoaderService(realmServiceName, plugIns, serviceTarget, newControllers);
        }
        if (authentication != null) {
            if (authentication.hasDefined("truststore")) {
                authTruststore = authentication.require("truststore");
                ServiceName ccName = this.addClientCertService(realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(ccName, CallbackHandlerService.class, securityRealmService.getCallbackHandlerService().injector());
            }
            if (authentication.hasDefined("local")) {
                ServiceName localName = this.addLocalService(authentication.require("local"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(localName, CallbackHandlerService.class, securityRealmService.getCallbackHandlerService().injector());
            }
            if (authentication.hasDefined("jaas")) {
                authenticationName = this.addJaasService(authentication.require("jaas"), realmServiceName, serviceTarget, newControllers, context.isNormalServer());
            } else if (authentication.hasDefined("ldap")) {
                authenticationName = this.addLdapService(authentication.require("ldap"), realmServiceName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("plug-in")) {
                authenticationName = this.addPlugInAuthenticationService(authentication.require("plug-in"), realmServiceName, plugInLoaderName, securityRealmService, serviceTarget, newControllers);
            } else if (authentication.hasDefined("properties")) {
                authenticationName = this.addPropertiesAuthenticationService(authentication.require("properties"), realmServiceName, realmName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("users")) {
                authenticationName = this.addUsersService(context, authentication.require("users"), realmServiceName, realmName, serviceTarget, newControllers);
            }
        }
        if (authorization != null) {
            if (authorization.hasDefined("properties")) {
                authorizationName = this.addPropertiesAuthorizationService(authorization.require("properties"), realmServiceName, realmName, serviceTarget, newControllers);
            } else if (authorization.hasDefined("plug-in")) {
                authorizationName = this.addPlugInAuthorizationService(authorization.require("plug-in"), realmServiceName, plugInLoaderName, realmName, serviceTarget, newControllers);
            }
        }
        if (authenticationName != null) {
            realmBuilder.addDependency(authenticationName, CallbackHandlerService.class, securityRealmService.getCallbackHandlerService().injector());
        }
        if (authorizationName != null) {
            realmBuilder.addDependency(authorizationName, SubjectSupplementalService.class, securityRealmService.getSubjectSupplementalInjector());
        }
        ModelNode ssl = null;
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ssl = serverIdentities.require("ssl");
            }
            if (serverIdentities.hasDefined("secret")) {
                ServiceName secretServiceName = this.addSecretService(context, serverIdentities.require("secret"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(secretServiceName, CallbackHandlerFactory.class, securityRealmService.getSecretCallbackFactory());
            }
        }
        if (ssl != null || authTruststore != null) {
            ServiceName sslServiceName = this.addSSLService(context, ssl, authTruststore, realmServiceName, serviceTarget, newControllers);
            realmBuilder.addDependency(sslServiceName, SSLIdentityService.class, securityRealmService.getSSLIdentityInjector());
        }
        realmBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController sc = realmBuilder.install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }

    private ServiceName addPlugInLoaderService(ServiceName realmServiceName, ModelNode plugInModel, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName plugInLoaderName = realmServiceName.append(new String[]{"plug-in-loader"});
        PlugInLoaderService loaderService = new PlugInLoaderService(plugInModel);
        ServiceBuilder builder = serviceTarget.addService(plugInLoaderName, (Service)loaderService);
        newControllers.add(builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return plugInLoaderName;
    }

    private ServiceName addClientCertService(ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName clientCertServiceName = realmServiceName.append(new String[]{"client_cert"});
        ClientCertCallbackHandler clientCertCallbackHandler = new ClientCertCallbackHandler();
        ServiceBuilder ccBuilder = serviceTarget.addService(clientCertServiceName, (Service)clientCertCallbackHandler);
        newControllers.add(ccBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return clientCertServiceName;
    }

    private ServiceName addJaasService(ModelNode jaas, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, boolean injectServerManager) {
        ServiceName jaasServiceName = realmServiceName.append(new String[]{"jaas"});
        JaasCallbackHandler jaasCallbackHandler = new JaasCallbackHandler(jaas.get("name").asString());
        ServiceBuilder jaasBuilder = serviceTarget.addService(jaasServiceName, (Service)jaasCallbackHandler);
        if (injectServerManager) {
            jaasBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"}), ServerSecurityManager.class, jaasCallbackHandler.getSecurityManagerValue());
        }
        newControllers.add(jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return jaasServiceName;
    }

    private ServiceName addLdapService(ModelNode ldap, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName ldapServiceName = realmServiceName.append(new String[]{"ldap"});
        UserLdapCallbackHandler ldapCallbackHandler = new UserLdapCallbackHandler(ldap);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapServiceName, (Service)ldapCallbackHandler);
        String connectionManager = ldap.require("connection").asString();
        ldapBuilder.addDependency(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{connectionManager}), ConnectionManager.class, ldapCallbackHandler.getConnectionManagerInjector());
        ServiceController serviceController = ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return ldapServiceName;
    }

    private ServiceName addLocalService(ModelNode local, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName localServiceName = realmServiceName.append(new String[]{"local"});
        String defaultUser = local.hasDefined("default-user") ? local.get("default-user").asString() : null;
        String allowedUsers = local.hasDefined("allowed-users") ? local.get("allowed-users").asString() : null;
        LocalCallbackHandlerService localCallbackHandler = new LocalCallbackHandlerService(defaultUser, allowedUsers);
        ServiceBuilder jaasBuilder = serviceTarget.addService(localServiceName, (Service)localCallbackHandler);
        newControllers.add(jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return localServiceName;
    }

    private ServiceName addPlugInAuthenticationService(ModelNode plugIn, ServiceName realmServiceName, ServiceName plugInLoaderName, SecurityRealmService registry, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName plugInServiceName = realmServiceName.append(new String[]{"plug-in-authentication"});
        PlugInAuthenticationCallbackHandler plugInService = new PlugInAuthenticationCallbackHandler(registry.getName(), plugIn);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInService);
        plugInBuilder.addDependency(plugInLoaderName, PlugInLoaderService.class, (Injector)plugInService.getPlugInLoaderServiceValue());
        newControllers.add(plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return plugInServiceName;
    }

    private ServiceName addPropertiesAuthenticationService(ModelNode properties, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties_authentication"});
        PropertiesCallbackHandler propsCallbackHandler = new PropertiesCallbackHandler(realmName, properties);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsCallbackHandler);
        if (properties.hasDefined("relative-to")) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(properties.get("relative-to").asString()), String.class, propsCallbackHandler.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return propsServiceName;
    }

    private ServiceName addPropertiesAuthorizationService(ModelNode properties, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties_authorization"});
        PropertiesSubjectSupplemental propsSubjectSupplemental = new PropertiesSubjectSupplemental(properties);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsSubjectSupplemental);
        if (properties.hasDefined("relative-to")) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(properties.get("relative-to").asString()), String.class, propsSubjectSupplemental.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return propsServiceName;
    }

    private ServiceName addPlugInAuthorizationService(ModelNode properties, ServiceName realmServiceName, ServiceName plugInLoaderName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName plugInServiceName = realmServiceName.append(new String[]{"plug-in-authorization"});
        PlugInSubjectSupplemental plugInSubjectSupplemental = new PlugInSubjectSupplemental(realmName, properties);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInSubjectSupplemental);
        plugInBuilder.addDependency(plugInLoaderName, PlugInLoaderService.class, (Injector)plugInSubjectSupplemental.getPlugInLoaderServiceValue());
        ServiceController serviceController = plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return plugInServiceName;
    }

    private ServiceName addSSLService(OperationContext context, ModelNode ssl, ModelNode trustStore, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName sslServiceName = realmServiceName.append(new String[]{"ssl"});
        ServiceName keystoreServiceName = null;
        KeyPair pair = null;
        if (ssl != null && ssl.hasDefined("keystore-path")) {
            keystoreServiceName = realmServiceName.append(new String[]{"keystore"});
            pair = this.addFileKeystoreService(context, ssl, keystoreServiceName, serviceTarget, newControllers);
        }
        ServiceName truststoreServiceName = null;
        if (trustStore != null) {
            truststoreServiceName = realmServiceName.append(new String[]{"truststore"});
            this.addFileKeystoreService(context, trustStore, truststoreServiceName, serviceTarget, newControllers);
        }
        String protocol = "TLS";
        if (ssl != null && ssl.hasDefined("protocol")) {
            protocol = ssl.get("protocol").asString();
        }
        SSLIdentityService sslIdentityService = new SSLIdentityService(protocol, pair == null ? null : pair.keystorePassword, pair == null ? null : pair.keyPassword);
        ServiceBuilder sslBuilder = serviceTarget.addService(sslServiceName, (Service)sslIdentityService);
        if (keystoreServiceName != null) {
            sslBuilder.addDependency(keystoreServiceName, KeyStore.class, sslIdentityService.getKeyStoreInjector());
        }
        if (truststoreServiceName != null) {
            sslBuilder.addDependency(truststoreServiceName, KeyStore.class, sslIdentityService.getTrustStoreInjector());
        }
        ServiceController serviceController = sslBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return sslServiceName;
    }

    private KeyPair addFileKeystoreService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        char[] keystorePassword = this.unmaskPassword(context, ssl.require("keystore-password"));
        char[] keyPassword = null;
        if (ssl.hasDefined("key-password")) {
            keyPassword = this.unmaskPassword(context, ssl.require("key-password"));
        }
        String path = ssl.require("keystore-path").asString();
        String alias = ssl.hasDefined("alias") ? ssl.require("alias").asString() : null;
        FileKeystoreService fileKeystoreService = new FileKeystoreService(path, keystorePassword, alias, keyPassword);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)fileKeystoreService);
        if (ssl.hasDefined("keystore-relative-to")) {
            serviceBuilder.addDependency(SecurityRealmAddHandler.pathName(ssl.require("keystore-relative-to").asString()), String.class, fileKeystoreService.getRelativeToInjector());
        }
        ServiceController serviceController = serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        KeyPair pair = new KeyPair();
        KeyPair.access$102(pair, keystorePassword);
        KeyPair.access$202(pair, keyPassword);
        return pair;
    }

    private ServiceName addSecretService(OperationContext context, ModelNode secret, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName secretServiceName = realmServiceName.append(new String[]{"secret"});
        ModelNode secretValueNode = secret.require("value");
        String resolvedValue = context.resolveExpressions(secretValueNode).asString();
        SecretIdentityService sis = new SecretIdentityService(resolvedValue, secretValueNode.asString().equals(resolvedValue));
        ServiceController serviceController = serviceTarget.addService(secretServiceName, (Service)sis).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return secretServiceName;
    }

    private ServiceName addUsersService(OperationContext context, ModelNode users, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName usersServiceName = realmServiceName.append(new String[]{"users"});
        UserDomainCallbackHandler usersCallbackHandler = new UserDomainCallbackHandler(realmName, this.unmaskUsersPasswords(context, users));
        ServiceBuilder usersBuilder = serviceTarget.addService(usersServiceName, (Service)usersCallbackHandler);
        ServiceController serviceController = usersBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return usersServiceName;
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    private char[] unmaskPassword(OperationContext context, ModelNode password) throws OperationFailedException {
        return context.resolveExpressions(password).asString().toCharArray();
    }

    private ModelNode unmaskUsersPasswords(OperationContext context, ModelNode users) throws OperationFailedException {
        users = users.clone();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = property.getValue();
            if (!user.hasDefined("password")) continue;
            user.set("password", context.resolveExpressions(user.get("password")).asString());
        }
        return users;
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ArrayList newControllers = new ArrayList();
            String realmName = ManagementUtil.getSecurityRealmName(operation);
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            INSTANCE.installServices(context, realmName, model, new ServiceVerificationHandler(), newControllers);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    for (ServiceController sc : newControllers) {
                        context.removeService(sc);
                    }
                }
            });
        }
    }

    private static class KeyPair {
        private char[] keystorePassword;
        private char[] keyPassword;

        private KeyPair() {
        }

        static /* synthetic */ char[] access$102(KeyPair x0, char[] x1) {
            x0.keystorePassword = x1;
            return x1;
        }

        static /* synthetic */ char[] access$202(KeyPair x0, char[] x1) {
            x0.keyPassword = x1;
            return x1;
        }
    }
}

