/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.io.IOException;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.StartException;

@MessageBundle(projectCode="JBAS")
public interface DomainManagementMessages {
    public static final DomainManagementMessages MESSAGES = (DomainManagementMessages)Messages.getBundle(DomainManagementMessages.class);

    @Message(id=15220, value="Unable to perform verification")
    public IOException cannotPerformVerification(@Cause Throwable var1);

    @Message(id=15221, value="Invalid Realm '%s' expected '%s'")
    public IllegalStateException invalidRealm(String var1, String var2);

    @Message(id=15222, value="Can't follow referral for authentication: %s")
    public NamingException nameNotFound(String var1);

    @Message(id=15223, value="No authentication mechanism defined in security realm.")
    public IllegalStateException noAuthenticationDefined();

    @Message(id=15224, value="No username provided.")
    public IOException noUsername();

    @Message(id=15225, value="No password to verify.")
    public IOException noPassword();

    @Message(id=15226, value="One of '%s' or '%s' required.")
    public IllegalArgumentException oneOfRequired(String var1, String var2);

    @Message(id=15227, value="Realm choice not currently supported.")
    public UnsupportedCallbackException realmNotSupported(@Param Callback var1);

    @Message(id=15228, value="Unable to load properties")
    public StartException unableToLoadProperties(@Cause Throwable var1);

    @Message(id=15229, value="Unable to start service")
    public StartException unableToStart(@Cause Throwable var1);

    @Message(id=15230, value="User '%s' not found.")
    public String userNotFound(String var1);

    @Message(id=15231, value="User '%s' not found in directory.")
    public IOException userNotFoundInDirectory(String var1);

    @Message(id=15232, value="No java.io.Console available to interact with user.")
    public IllegalStateException noConsoleAvailable();

    @Message(id=15233, value="JBOSS_HOME environment variable not set.")
    public String jbossHomeNotSet();

    @Message(id=15234, value="No %s files found.")
    public String propertiesFileNotFound(String var1);

    @Message(id=0, value="Enter the details of the new user to add.")
    public String enterNewUserDetails();

    @Message(id=0, value="Realm (%s)")
    public String realmPrompt(String var1);

    @Message(id=0, value="Username")
    public String usernamePrompt();

    @Message(id=0, value="Username (%s)")
    public String usernamePrompt(String var1);

    @Message(id=15235, value="No Username entered, exiting.")
    public String noUsernameExiting();

    @Message(id=0, value="Password")
    public String passwordPrompt();

    @Message(id=15236, value="No Password entered, exiting.")
    public String noPasswordExiting();

    @Message(id=0, value="Re-enter Password")
    public String passwordConfirmationPrompt();

    @Message(id=15237, value="The passwords do not match.")
    public String passwordMisMatch();

    @Message(id=15238, value="Username must not match the password.")
    public String usernamePasswordMatch();

    @Message(id=15239, value="Only alpha/numeric usernames accepted.")
    public String usernameNotAlphaNumeric();

    @Message(id=0, value="About to add user '%s' for realm '%s'")
    public String aboutToAddUser(String var1, String var2);

    @Message(id=0, value="Is this correct")
    public String isCorrectPrompt();

    @Message(id=0, value="The username '%s' is easy to guess")
    public String usernameEasyToGuess(String var1);

    @Message(id=0, value="Are you sure you want to add user '%s' yes/no?")
    public String sureToAddUser(String var1);

    @Message(id=15240, value="Invalid response. (Valid responses are %s and %s)")
    public String invalidConfirmationResponse(String var1, String var2);

    @Message(id=0, value="Added user '%s' to file '%s'")
    public String addedUser(String var1, String var2);

    @Message(id=15241, value="Unable to add user to %s due to error %s")
    public String unableToAddUser(String var1, String var2);

    @Message(id=15242, value="Unable to add load users from %s due to error %s")
    public String unableToLoadUsers(String var1, String var2);

    @Message(id=15243, value="The user '%s' already exists in at least one properties file.")
    public String duplicateUser(String var1);

    @Message(id=0, value="Error")
    public String errorHeader();

    @Message(id=0, value="Is this new user going to be used for one AS process to connect to another AS process? %ne.g. for a slave host controller connecting to the master or for a Remoting connection for server to server EJB calls.")
    public String serverUser();

    @Message(id=0, value="yes/no?")
    public String yesNo();

    @Message(id=0, value="To represent the user add the following to the server-identities definition <secret value=\"%s\" />")
    public String secretElement(String var1);

    @Message(id=15244, value="Configuration for security realm '%s' includes multiple username/password based authentication mechanisms (%s). Only one is allowed")
    public OperationFailedException multipleAuthenticationMechanismsDefined(String var1, Set<String> var2);

    @Message(id=15246, value="One of '%s' or '%s' required.")
    public OperationFailedException operationFailedOneOfRequired(String var1, String var2);

    @Message(id=15247, value="Only one of '%s' or '%s' is required.")
    public OperationFailedException operationFailedOnlyOneOfRequired(String var1, String var2);

    @Message(id=15248, value="'%s' can not be null.")
    public IllegalArgumentException canNotBeNull(String var1);

    @Message(id=15249, value="No security context has been established.")
    public String noSecurityContextEstablished();

    @Message(id=15250, value="An unexpected number (%d) of RealmUsers are associated with the SecurityContext.")
    public String unexpectedNumberOfRealmUsers(int var1);

    @Message(id=0, value="What type of user do you wish to add? %n a) Management User (mgmt-users.properties) %n b) Application User (application-users.properties)")
    public String filePrompt();

    @Message(id=0, value="What roles do you want this user to belong to? (Please enter a comma separated list, or leave blank for none)")
    public String rolesPrompt();

    @Message(id=0, value="Added user '%s' with roles %s to file '%s'")
    public String addedRoles(String var1, String var2, String var3);

    @Message(id=15251, value="Invalid response. (Valid responses are A, a, B, or b)")
    public String invalidChoiceResponse();

    @Message(id=0, value="User '%s' already exits, would you like to update the existing user password and roles")
    public String aboutToUpdateUser(String var1);

    @Message(id=0, value="Updated user '%s' to file '%s'")
    public String updateUser(String var1, String var2);

    @Message(id=15254, value="Unable to update user to %s due to error %s")
    public String unableToUpdateUser(String var1, String var2);

    @Message(id=0, value="Updated user '%s' with roles %s to file '%s'")
    public String updatedRoles(String var1, String var2, String var3);

    @Message(id=15255, value="The user '%s' is not allowed in a local authentication.")
    public IOException invalidLocalUser(String var1);

    @Message(id=15256, value="Multiple CallbackHandlerServices for the same mechanism (%s)")
    public StartException multipleCallbackHandlerForMechanism(String var1);

    @Message(id=15259, value="No CallbackHandler available for mechanism %s in realm %s")
    public IllegalStateException noCallbackHandlerForMechanism(String var1, String var2);

    @Message(id=15260, value="No plug in providers found for module name %s")
    public IllegalArgumentException noPlugInProvidersLoaded(String var1);

    @Message(id=15261, value="Unable to load plug-in for module %s due to error (%s)")
    public IllegalArgumentException unableToLoadPlugInProviders(String var1, String var2);

    @Message(id=15262, value="No authentication plug-in found for name %s")
    public IllegalArgumentException noAuthenticationPlugInFound(String var1);

    @Message(id=15263, value="Unable to initialise plug-in %s due to error %s")
    public IllegalStateException unableToInitialisePlugIn(String var1, String var2);

    @Message(id=15264, value="Password is not strong enough, it is '%s'. It should be at least '%s'.")
    public String passwordNotStrongEnough(String var1, String var2);

    @Message(id=152565, value="Password must not be equal to '%s', this value is restricted.")
    public String passwordMustNotBeEqual(String var1);

    @Message(id=15266, value="Password must have at least one digit.")
    public String passwordMustHaveDigit();

    @Message(id=15267, value="Password must have at least one non-alphanumeric symbol.")
    public String passwordMustHaveSymbol();

    @Message(id=15268, value="Password must have at least one alphanumeric character.")
    public String passwordMustHaveAlpha();

    @Message(id=15269, value="Password must have at least '%s' characters!")
    public String passwordNotLongEnough(int var1);

    @Message(id=0, value="Are you sure you want to set password '%s' yes/no?")
    public String sureToSetPassword(String var1);

    @Message(id=0, value="Usage: ./add-user.sh [args...]%nwhere args include:")
    public String argUsage();

    @Message(id=0, value="If set add an application user instead of a management user")
    public String argApplicationUsers();

    @Message(id=0, value="Define the system property to use for the domain config directory (default is \"jboss.domain.config.dir\")")
    public String argDomainConfigDirUsers();

    @Message(id=0, value="Define the system property to use for the server config directory (default is \"jboss.server.config.dir\")")
    public String argServerConfigDirUsers();

    @Message(id=0, value="Password of the user. Should not be same as the username")
    public String argPassword();

    @Message(id=0, value="Name of the user")
    public String argUser();

    @Message(id=0, value="Name of the realm used to secure the management interfaces (default is \"ManagementRealm\")")
    public String argRealm();

    @Message(id=0, value="Activate the silent mode (no output to the console)")
    public String argSilent();

    @Message(id=0, value="Comma-separated list of roles for the user (only for application users, see -a)")
    public String argRole();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="yes")
    public String yes();

    @Message(id=0, value="y")
    public String shortYes();

    @Message(id=0, value="no")
    public String no();

    @Message(id=0, value="n")
    public String shortNo();

    @Message(id=0, value="The realm name supplied must match the name used by the server configuration which by default would be '%s'")
    public String alternativeRealm(String var1);

    @Message(id=0, value="Are you sure you want to set the realm to '%s'")
    public String realmConfirmation(String var1);
}

