/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.AddUser;
import org.jboss.as.domain.management.security.state.ConfirmationChoice;
import org.jboss.as.domain.management.security.state.PromptNewUserState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;
import org.jboss.as.domain.management.security.state.UpdateUser;

public class PreModificationState
implements State {
    private final ConsoleWrapper theConsole;
    private StateValues stateValues;

    public PreModificationState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (!stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        State continuingState;
        if (this.stateValues.isExistingUser()) {
            continuingState = new UpdateUser(this.theConsole, this.stateValues);
        } else {
            AddUser addState = new AddUser(this.theConsole, this.stateValues);
            if (this.stateValues.isSilentOrNonInteractive()) {
                continuingState = addState;
            } else {
                String message = DomainManagementMessages.MESSAGES.aboutToAddUser(this.stateValues.getUserName(), this.stateValues.getRealm());
                String prompt = DomainManagementMessages.MESSAGES.isCorrectPrompt() + " " + DomainManagementMessages.MESSAGES.yes() + "/" + DomainManagementMessages.MESSAGES.no() + "?";
                continuingState = new ConfirmationChoice(this.theConsole, message, prompt, (State)addState, (State)new PromptNewUserState(this.theConsole, this.stateValues));
            }
        }
        return continuingState;
    }
}

